/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ModifySelectionJob
extends BatchDocumentJob {
    protected final ValuePropertyMetadata propertyMetadata;
    protected final Object newValue;

    public ModifySelectionJob(ValuePropertyMetadata propertyMetadata, Object newValue, EditorController editorController) {
        super(editorController);
        this.propertyMetadata = propertyMetadata;
        this.newValue = newValue;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        HashSet<FXOMInstance> candidates = new HashSet<FXOMInstance>();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject fXOMObject : osg.getItems()) {
                if (!(fXOMObject instanceof FXOMInstance)) continue;
                candidates.add((FXOMInstance)fXOMObject);
            }
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
            DesignHierarchyMask mask = new DesignHierarchyMask(gsg.getAncestor());
            for (int index : gsg.getIndexes()) {
                FXOMObject constraints = null;
                switch (gsg.getType()) {
                    case COLUMN: {
                        constraints = mask.getColumnConstraintsAtIndex(index);
                        break;
                    }
                    case ROW: {
                        constraints = mask.getRowConstraintsAtIndex(index);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                assert (constraints instanceof FXOMInstance);
                candidates.add((FXOMInstance)constraints);
            }
        } else assert (selection.getGroup() == null) : "Add implementation for " + selection.getGroup();
        for (FXOMInstance fxomInstance : candidates) {
            ModifyObjectJob modifyObjectJob = new ModifyObjectJob(fxomInstance, this.propertyMetadata, this.newValue, this.getEditorController());
            if (!modifyObjectJob.isExecutable()) continue;
            result.add(modifyObjectJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result;
        List<Job> subJobs = this.getSubJobs();
        int subJobCount = subJobs.size();
        switch (subJobCount) {
            case 0: {
                result = "Unexecutable Set";
                break;
            }
            case 1: {
                result = subJobs.get(0).getDescription();
                break;
            }
            default: {
                result = I18N.getString("label.action.edit.set.n", this.propertyMetadata.getName().toString(), subJobCount);
            }
        }
        return result;
    }
}

