/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import java.util.List;

public abstract class BatchSelectionJob
extends BatchDocumentJob {
    private AbstractSelectionGroup oldSelectionGroup;
    private AbstractSelectionGroup newSelectionGroup;

    public BatchSelectionJob(EditorController editorController) {
        super(editorController);
    }

    protected final AbstractSelectionGroup getOldSelectionGroup() {
        return this.oldSelectionGroup;
    }

    protected abstract AbstractSelectionGroup getNewSelectionGroup();

    @Override
    public final void execute() {
        Selection selection = this.getEditorController().getSelection();
        try {
            selection.beginUpdate();
            this.oldSelectionGroup = selection.getGroup() == null ? null : selection.getGroup().clone();
            super.execute();
            this.newSelectionGroup = this.getNewSelectionGroup();
            selection.select(this.newSelectionGroup);
            selection.endUpdate();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public final void undo() {
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        super.undo();
        selection.select(this.oldSelectionGroup);
        selection.endUpdate();
    }

    @Override
    public final void redo() {
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        super.redo();
        selection.select(this.newSelectionGroup);
        selection.endUpdate();
    }

    @Override
    protected abstract List<Job> makeSubJobs();
}

