/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.target;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsAccessoryJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.layout.BorderPane;

public class AccessoryDropTarget
extends AbstractDropTarget {
    private final FXOMInstance targetContainer;
    private final DesignHierarchyMask.Accessory accessory;

    public AccessoryDropTarget(FXOMInstance targetContainer, DesignHierarchyMask.Accessory accessory) {
        assert (targetContainer != null);
        this.targetContainer = targetContainer;
        this.accessory = accessory;
    }

    public DesignHierarchyMask.Accessory getAccessory() {
        return this.accessory;
    }

    @Override
    public FXOMObject getTargetObject() {
        return this.targetContainer;
    }

    @Override
    public boolean acceptDragSource(AbstractDragSource dragSource) {
        FXOMObject draggedObject;
        DesignHierarchyMask m;
        assert (dragSource != null);
        boolean result = dragSource.getDraggedObjects().size() != 1 ? false : (m = new DesignHierarchyMask(this.targetContainer)).isAcceptingAccessory(this.accessory, draggedObject = dragSource.getDraggedObjects().get(0)) && m.getAccessory(this.accessory) == null;
        return result;
    }

    @Override
    public Job makeDropJob(AbstractDragSource dragSource, EditorController editorController) {
        assert (this.acceptDragSource(dragSource));
        assert (editorController != null);
        boolean shouldRefreshSceneGraph = true;
        BatchJob result = new BatchJob(editorController, true, dragSource.makeDropJobDescription());
        FXOMObject draggedObject = dragSource.getDraggedObjects().get(0);
        FXOMObject currentParent = draggedObject.getParentObject();
        if (currentParent != null) {
            result.addSubJob(new RemoveObjectJob(draggedObject, editorController));
        }
        InsertAsAccessoryJob j = new InsertAsAccessoryJob(draggedObject, this.targetContainer, this.accessory, editorController);
        result.addSubJob(j);
        if (this.targetContainer.getSceneGraphObject() instanceof BorderPane && draggedObject instanceof FXOMInstance) {
            FXOMInstance draggedInstance = (FXOMInstance)draggedObject;
            PropertyName alignmentName = new PropertyName("alignment", BorderPane.class);
            EnumerationPropertyMetadata alignmentMeta = new EnumerationPropertyMetadata(alignmentName, Pos.class, "UNUSED", true, InspectorPath.UNUSED);
            ModifyObjectJob alignmentJob = new ModifyObjectJob(draggedInstance, alignmentMeta, Pos.CENTER.toString(), editorController);
            result.addSubJob(alignmentJob);
        }
        assert (result.isExecutable());
        return result;
    }

    @Override
    public boolean isSelectRequiredAfterDrop() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.targetContainer);
        hash = 97 * hash + (this.accessory != null ? this.accessory.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessoryDropTarget other = (AccessoryDropTarget)obj;
        if (!Objects.equals(this.targetContainer, other.targetContainer)) {
            return false;
        }
        return this.accessory == other.accessory;
    }

    public String toString() {
        return "AccessoryDropTarget{targetContainer=" + this.targetContainer + ", accessory=" + (Object)((Object)this.accessory) + '}';
    }
}

