/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class AlarmFactory {
    @NotNull
    private static volatile AlarmFactory ourInstance = new AlarmFactory();

    @NotNull
    public static AlarmFactory getInstance() {
        AlarmFactory alarmFactory = ourInstance;
        if (alarmFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AlarmFactory", "getInstance"));
        }
        return alarmFactory;
    }

    public static void setAlarmFactory(@NotNull AlarmFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/AlarmFactory", "setAlarmFactory"));
        }
        ourInstance = factory;
    }

    @NotNull
    public Alarm create() {
        Alarm alarm = new Alarm();
        if (alarm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AlarmFactory", "create"));
        }
        return alarm;
    }

    @NotNull
    public Alarm create(@NotNull Alarm.ThreadToUse threadToUse) {
        if (threadToUse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadToUse", "com/intellij/util/AlarmFactory", "create"));
        }
        Alarm alarm = new Alarm(threadToUse);
        if (alarm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AlarmFactory", "create"));
        }
        return alarm;
    }

    @NotNull
    public Alarm create(@NotNull Alarm.ThreadToUse threadToUse, @NotNull Disposable parentDisposable) {
        if (threadToUse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadToUse", "com/intellij/util/AlarmFactory", "create"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/AlarmFactory", "create"));
        }
        Alarm alarm = new Alarm(threadToUse, parentDisposable);
        if (alarm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AlarmFactory", "create"));
        }
        return alarm;
    }
}

