/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Alarm
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.Alarm");
    private volatile boolean myDisposed;
    private final List<Request> myRequests;
    private final List<Request> myPendingRequests;
    private final ScheduledExecutorService myExecutorService;
    private final Object LOCK;
    final ThreadToUse myThreadToUse;
    private JComponent myActivationComponent;

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.cancelAllRequests();
            if (this.myExecutorService != EdtExecutorService.getScheduledExecutorInstance()) {
                this.myExecutorService.shutdownNow();
            }
        }
    }

    private void checkDisposed() {
        LOG.assertTrue(!this.myDisposed, (Object)"Already disposed");
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/Alarm", "<init>"));
        }
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(@NotNull ThreadToUse threadToUse) {
        if (threadToUse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadToUse", "com/intellij/util/Alarm", "<init>"));
        }
        this(threadToUse, null);
    }

    public Alarm(@NotNull ThreadToUse threadToUse, @Nullable Disposable parentDisposable) {
        if (threadToUse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadToUse", "com/intellij/util/Alarm", "<init>"));
        }
        this.myRequests = new SmartList();
        this.myPendingRequests = new SmartList();
        this.LOCK = new Object();
        this.myThreadToUse = threadToUse;
        ScheduledExecutorService scheduledExecutorService = this.myExecutorService = threadToUse == ThreadToUse.SWING_THREAD ? EdtExecutorService.getScheduledExecutorInstance() : AppExecutorUtil.createBoundedScheduledExecutorService((String)"Alarm pool", (int)1);
        if (parentDisposable == null) {
            if (threadToUse == ThreadToUse.POOLED_THREAD || threadToUse != ThreadToUse.SWING_THREAD) {
                boolean crash = threadToUse == ThreadToUse.POOLED_THREAD || ApplicationManager.getApplication().isUnitTestMode();
                IllegalArgumentException t = new IllegalArgumentException("You must provide parent Disposable for non-swing thread Alarm");
                if (crash) {
                    throw t;
                }
                LOG.warn((Throwable)t);
            }
        } else {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public void addRequest(final @NotNull Runnable request, final int delay, boolean runWithActiveFrameOnly) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "addRequest"));
        }
        if (runWithActiveFrameOnly && !ApplicationManager.getApplication().isActive()) {
            MessageBus bus = ApplicationManager.getApplication().getMessageBus();
            final MessageBusConnection connection = bus.connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener.Adapter(){

                @Override
                public void applicationActivated(IdeFrame ideFrame) {
                    connection.disconnect();
                    Alarm.this.addRequest(request, delay);
                }
            });
        } else {
            this.addRequest(request, delay);
        }
    }

    private ModalityState getModalityState() {
        if (this.myThreadToUse != ThreadToUse.SWING_THREAD) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        return application.getDefaultModalityState();
    }

    public void addRequest(@NotNull Runnable request, long delayMillis) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "addRequest"));
        }
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addRequest(@NotNull Runnable request, int delayMillis) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "addRequest"));
        }
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addComponentRequest(@NotNull Runnable request, int delay) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "addComponentRequest"));
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request, delay, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addComponentRequest(@NotNull Runnable request, long delayMillis) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "addComponentRequest"));
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addRequest(@NotNull Runnable request, int delayMillis, @Nullable ModalityState modalityState) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "addRequest"));
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    /*
     * WARNING - void declaration
     */
    public void addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        void modalityState2;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "addRequest"));
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, (ModalityState)modalityState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void _addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "_addRequest"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            void modalityState2;
            this.checkDisposed();
            Request requestToSchedule = new Request(request, (ModalityState)modalityState2, delayMillis);
            if (this.myActivationComponent == null || this.myActivationComponent.isShowing()) {
                this._add(requestToSchedule);
            } else if (!this.myPendingRequests.contains(requestToSchedule)) {
                this.myPendingRequests.add(requestToSchedule);
            }
        }
    }

    private void _add(@NotNull Request requestToSchedule) {
        if (requestToSchedule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestToSchedule", "com/intellij/util/Alarm", "_add"));
        }
        requestToSchedule.schedule();
        this.myRequests.add(requestToSchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPending() {
        Object object = this.LOCK;
        synchronized (object) {
            for (Request each : this.myPendingRequests) {
                this._add(each);
            }
            this.myPendingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(@NotNull Runnable request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "cancelRequest"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelRequest(request, this.myRequests);
            this.cancelRequest(request, this.myPendingRequests);
            return true;
        }
    }

    private void cancelRequest(@NotNull Runnable request, @NotNull List<Request> list) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/Alarm", "cancelRequest"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/Alarm", "cancelRequest"));
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Request r = list.get(i);
            if (r.myTask != request) continue;
            r.cancel();
            list.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.cancelAllRequests(this.myRequests);
            this.cancelAllRequests(this.myPendingRequests);
            return count;
        }
    }

    private int cancelAllRequests(@NotNull List<Request> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/Alarm", "cancelAllRequests"));
        }
        int count = 0;
        for (Request request : list) {
            ++count;
            request.cancel();
        }
        list.clear();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        SmartList requests;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.myRequests.isEmpty()) {
                return;
            }
            requests = new SmartList();
            for (Request request : this.myRequests) {
                Runnable existingTask = request.cancel();
                if (existingTask == null) continue;
                requests.add(Pair.create((Object)request, (Object)existingTask));
            }
            this.myRequests.clear();
        }
        for (Pair request : requests) {
            Object object = this.LOCK;
            synchronized (object) {
                ((Request)request.first).myTask = (Runnable)request.second;
            }
            ((Request)request.first).run();
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void waitForAllExecuted(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Request> requests;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/Alarm", "waitForAllExecuted"));
        }
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            requests = new ArrayList<Request>(this.myRequests);
        }
        for (Request request : requests) {
            void unit;
            Future future;
            Object object = this.LOCK;
            synchronized (object) {
                future = request.myFuture;
            }
            if (future == null) continue;
            future.get(timeout, (TimeUnit)unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.isEmpty();
        }
    }

    protected boolean isEdt() {
        return Alarm.isEventDispatchThread();
    }

    public static boolean isEventDispatchThread() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isDispatchThread() || EventQueue.isDispatchThread();
    }

    @NotNull
    public Alarm setActivationComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/Alarm", "setActivationComponent"));
        }
        this.myActivationComponent = component;
        new UiNotifyConnector(component, new Activatable(){

            @Override
            public void showNotify() {
                Alarm.this.flushPending();
            }

            @Override
            public void hideNotify() {
            }
        });
        Alarm alarm = this;
        if (alarm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Alarm", "setActivationComponent"));
        }
        return alarm;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;
        private final long myDelay;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Request(@Nullable Runnable task, ModalityState modalityState, long delayMillis) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/Alarm$Request", "<init>"));
            }
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                this.myTask = task;
                this.myModalityState = modalityState;
                this.myDelay = delayMillis;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Alarm.this.myDisposed) {
                    return;
                }
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    if (this.myTask == null) {
                        return;
                    }
                }
                Runnable scheduledTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Runnable task;
                        Object object = Alarm.this.LOCK;
                        synchronized (object) {
                            task = Request.this.myTask;
                            Request.this.myTask = null;
                            Alarm.this.myRequests.remove(Request.this);
                            Request.this.myFuture = null;
                        }
                        if (task == null) {
                            return;
                        }
                        if (Alarm.this.myThreadToUse == ThreadToUse.SWING_THREAD && !Alarm.this.isEdt()) {
                            EdtInvocationManager.getInstance().invokeLater(() -> {
                                if (!Alarm.this.myDisposed) {
                                    QueueProcessor.runSafely(task);
                                }
                            });
                        } else {
                            QueueProcessor.runSafely(task);
                        }
                    }

                    public String toString() {
                        return "ScheduledTask " + Request.this;
                    }
                };
                if (this.myModalityState == null) {
                    scheduledTask.run();
                } else {
                    Application app = ApplicationManager.getApplication();
                    if (app == null) {
                        SwingUtilities.invokeLater(scheduledTask);
                    } else {
                        app.invokeLater(scheduledTask, this.myModalityState);
                    }
                }
            }
            catch (ProcessCanceledException scheduledTask) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        private void schedule() {
            this.myFuture = Alarm.this.myExecutorService.schedule(this, this.myDelay, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Runnable cancel() {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                Future<?> future = this.myFuture;
                if (future != null) {
                    future.cancel(false);
                    this.myFuture = null;
                }
                Runnable task = this.myTask;
                this.myTask = null;
                return task;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Runnable task;
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                task = this.myTask;
            }
            return super.toString() + (task != null ? ": " + task : "");
        }
    }

    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        POOLED_THREAD,
        OWN_THREAD;

    }
}

