/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkType
implements SdkTypeId {
    public static final ExtensionPointName<SdkType> EP_NAME = ExtensionPointName.create((String)"com.intellij.sdkType");
    private final String myName;

    public SdkType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/projectRoots/SdkType", "<init>"));
        }
        this.myName = name;
    }

    @Nullable
    public abstract String suggestHomePath();

    @NotNull
    public Collection<String> suggestHomePaths() {
        String home = this.suggestHomePath();
        List<String> list = home != null ? Collections.singletonList(home) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "suggestHomePaths"));
        }
        return list;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/SdkType", "adjustSelectedSdkHome"));
        }
        String string = homePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "adjustSelectedSdkHome"));
        }
        return string;
    }

    public abstract boolean isValidSdkHome(String var1);

    @Override
    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SdkType", "getVersionString"));
        }
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(String sdkHome) {
        return null;
    }

    public abstract String suggestSdkName(String var1, String var2);

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SdkType", "setupSdkPaths"));
        }
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SdkType", "setupSdkPaths"));
        }
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "com/intellij/openapi/projectRoots/SdkType", "setupSdkPaths"));
        }
        this.setupSdkPaths(sdk);
        return true;
    }

    @Nullable
    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel var1, @NotNull SdkModificator var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, Element additional) {
        if (currentSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSdk", "com/intellij/openapi/projectRoots/SdkType", "loadAdditionalData"));
        }
        return this.loadAdditionalData(additional);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "getName"));
        }
        return string;
    }

    @NotNull
    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.jdks" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "getHelpTopic"));
        }
        return "preferences.jdks";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = IconUtil.getAddIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "getIconForAddAction"));
        }
        return icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            @Override
            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                String selectedPath;
                boolean valid;
                if (files.length != 0 && !(valid = SdkType.this.isValidSdkHome(selectedPath = files[0].getPath())) && !(valid = SdkType.this.isValidSdkHome(SdkType.this.adjustSelectedSdkHome(selectedPath)))) {
                    String message = files[0].isDirectory() ? ProjectBundle.message("sdk.configure.home.invalid.error", SdkType.this.getPresentableName()) : ProjectBundle.message("sdk.configure.home.file.invalid.error", SdkType.this.getPresentableName());
                    throw new Exception(message);
                }
            }
        };
        descriptor.setTitle(ProjectBundle.message("sdk.configure.home.title", this.getPresentableName()));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "getHomeChooserDescriptor"));
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public String getHomeFieldLabel() {
        String string = ProjectBundle.message("sdk.configure.type.home.path", this.getPresentableName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "getHomeFieldLabel"));
        }
        return string;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SdkType", "getDefaultDocumentationUrl"));
        }
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return null;
    }

    @NotNull
    public static SdkType[] getAllTypes() {
        ArrayList allTypes = new ArrayList();
        Collections.addAll(allTypes, ApplicationManager.getApplication().getComponents(SdkType.class));
        Collections.addAll(allTypes, Extensions.getExtensions(EP_NAME));
        SdkType[] sdkTypeArray = allTypes.toArray(new SdkType[allTypes.size()]);
        if (sdkTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "getAllTypes"));
        }
        return sdkTypeArray;
    }

    @NotNull
    public static <T extends SdkType> T findInstance(@NotNull Class<T> sdkTypeClass) {
        if (sdkTypeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkTypeClass", "com/intellij/openapi/projectRoots/SdkType", "findInstance"));
        }
        for (SdkType sdkType : (SdkType[])Extensions.getExtensions(EP_NAME)) {
            if (!sdkTypeClass.equals(sdkType.getClass())) continue;
            SdkType sdkType2 = sdkType;
            if (sdkType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "findInstance"));
            }
            return (T)sdkType2;
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/SdkType", "findInstance"));
        }
        return null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/SdkType", "isRootTypeApplicable"));
        }
        return true;
    }

    public boolean supportsCustomCreateUI() {
        return false;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "com/intellij/openapi/projectRoots/SdkType", "showCustomCreateUI"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/openapi/projectRoots/SdkType", "showCustomCreateUI"));
        }
        if (sdkCreatedCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkCreatedCallback", "com/intellij/openapi/projectRoots/SdkType", "showCustomCreateUI"));
        }
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/SdkType", "sdkHasValidPath"));
        }
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public String sdkPath(@NotNull VirtualFile homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/SdkType", "sdkPath"));
        }
        return homePath.getPath();
    }
}

