/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import java.lang.reflect.Field;

public abstract class PublicFieldBasedOptionDescription
extends BooleanOptionDescription {
    private final String myFieldName;

    public PublicFieldBasedOptionDescription(String option, String configurableId, String fieldName) {
        super(option, configurableId);
        this.myFieldName = fieldName;
    }

    public abstract Object getInstance();

    protected void fireUpdated() {
    }

    @Override
    public boolean isOptionEnabled() {
        try {
            Field field = this.getInstance().getClass().getField(this.myFieldName);
            return field.getBoolean(this.getInstance());
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void setOptionState(boolean enabled) {
        try {
            Field field = this.getInstance().getClass().getField(this.myFieldName);
            field.setBoolean(this.getInstance(), enabled);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.fireUpdated();
    }
}

