/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PathsList;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleJavaParameters
extends SimpleProgramParameters {
    private static final Logger LOG = Logger.getInstance(SimpleJavaParameters.class);
    private Sdk myJdk;
    private String myMainClass;
    private final PathsList myClassPath = new PathsList();
    private String myModuleName;
    private final PathsList myModulePath = new PathsList();
    private final ParametersList myVmParameters = new ParametersList();
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    private boolean myUseDynamicClasspath;
    private boolean myUseClasspathJar = false;
    private boolean myUseDynamicVMOptions;
    private boolean myPassProgramParametersViaClasspathJar;
    private String myJarPath;

    public String getMainClass() {
        return this.myMainClass;
    }

    public String getJarPath() {
        return this.myJarPath;
    }

    @Nullable
    public Sdk getJdk() {
        return this.myJdk;
    }

    public void setJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    public void setMainClass(@NonNls String mainClass) {
        this.myMainClass = mainClass;
    }

    public void setJarPath(@NonNls String jarPath) {
        this.myJarPath = jarPath;
    }

    public PathsList getClassPath() {
        return this.myClassPath;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    public PathsList getModulePath() {
        return this.myModulePath;
    }

    public ParametersList getVMParametersList() {
        return this.myVmParameters;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(@Nullable Charset charset) {
        this.myCharset = charset;
    }

    public void setUseDynamicClasspath(boolean useDynamicClasspath) {
        this.myUseDynamicClasspath = useDynamicClasspath;
    }

    public void setUseDynamicVMOptions(boolean useDynamicVMOptions) {
        this.myUseDynamicVMOptions = useDynamicVMOptions;
    }

    public boolean isDynamicVMOptions() {
        return this.myUseDynamicVMOptions;
    }

    public boolean isUseClasspathJar() {
        return this.myUseClasspathJar;
    }

    public void setUseClasspathJar(boolean useClasspathJar) {
        this.myUseClasspathJar = useClasspathJar;
    }

    public boolean isPassProgramParametersViaClasspathJar() {
        return this.myPassProgramParametersViaClasspathJar;
    }

    public void setPassProgramParametersViaClasspathJar(boolean passProgramParametersViaClasspathJar) {
        LOG.assertTrue(this.myUseClasspathJar);
        this.myPassProgramParametersViaClasspathJar = passProgramParametersViaClasspathJar;
    }

    @NotNull
    public GeneralCommandLine toCommandLine() {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            throw new IllegalArgumentException("SDK should be defined");
        }
        String exePath = ((JavaSdkType)((Object)jdk.getSdkType())).getVMExecutablePath(jdk);
        GeneralCommandLine generalCommandLine = JdkUtil.setupJVMCommandLine(exePath, this, this.myUseDynamicClasspath);
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/SimpleJavaParameters", "toCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    public OSProcessHandler createOSProcessHandler() throws ExecutionException {
        OSProcessHandler processHandler = new OSProcessHandler(this.toCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/SimpleJavaParameters", "createOSProcessHandler"));
        }
        return oSProcessHandler;
    }
}

