/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.Cache;
import java.util.Arrays;

public class SolverVariable {
    private static final boolean INTERNAL_DEBUG = false;
    public static final boolean USE_LIST = false;
    static int uniqueId = 1;
    private String mName;
    public int id = -1;
    public int definitionId = -1;
    public float computedValue;
    Type mType;
    Strength mStrength = Strength.WEAK;
    private final Cache mCache;
    ArrayRow[] mClientEquations = new ArrayRow[8];
    int mClientEquationsCount = 0;

    public static String getUniqueName() {
        return "V" + ++uniqueId;
    }

    public static String getUniqueName(Type type, Strength strength) {
        ++uniqueId;
        switch (type) {
            case UNRESTRICTED: {
                return "U" + uniqueId;
            }
            case CONSTANT: {
                return "C" + uniqueId;
            }
            case SLACK: {
                return "S" + uniqueId;
            }
            case ERROR: {
                if (strength == Strength.STRONG) {
                    return "E" + uniqueId;
                }
                return "e" + uniqueId;
            }
        }
        return "V" + uniqueId;
    }

    public SolverVariable(Cache cache, String name, Type type) {
        this.mCache = cache;
        this.mName = name;
        this.mType = type;
    }

    public SolverVariable(Cache cache, Type type) {
        this.mCache = cache;
        this.mType = type;
    }

    public void addClientEquation(ArrayRow equation) {
        for (int i = 0; i < this.mClientEquationsCount; ++i) {
            if (this.mClientEquations[i] != equation) continue;
            return;
        }
        if (this.mClientEquationsCount >= this.mClientEquations.length) {
            this.mClientEquations = Arrays.copyOf(this.mClientEquations, this.mClientEquations.length * 2);
        }
        this.mClientEquations[this.mClientEquationsCount] = equation;
        ++this.mClientEquationsCount;
    }

    public void removeClientEquation(ArrayRow equation) {
        for (int i = 0; i < this.mClientEquationsCount; ++i) {
            if (this.mClientEquations[i] != equation) continue;
            System.arraycopy(this.mClientEquations, i + 1, this.mClientEquations, i, this.mClientEquationsCount - i - 1);
            --this.mClientEquationsCount;
            return;
        }
    }

    public void reset() {
        this.mName = null;
        this.mType = Type.UNKNOWN;
        this.mStrength = Strength.STRONG;
        this.id = -1;
        this.definitionId = -1;
        this.computedValue = 0.0f;
        this.mClientEquationsCount = 0;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setType(Type type) {
        this.mType = type;
    }

    public void setStrength(Strength s) {
        this.mStrength = s;
    }

    public String toString() {
        String result = "";
        result = result + this.mName;
        return result;
    }

    public static enum Strength {
        STRONG,
        WEAK,
        UNKNOWN;

    }

    public static enum Type {
        UNRESTRICTED,
        CONSTANT,
        SLACK,
        ERROR,
        UNKNOWN;

    }

    final class Link {
        ArrayRow row;
        Link next;

        Link() {
        }
    }
}

