/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxRootTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticSetterAttributeDescriptor;

public class JavaFxImportsOptimizer
implements ImportOptimizer {
    public boolean supports(PsiFile file) {
        return JavaFxFileTypeFactory.isFxml(file);
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        XmlProlog newImportList;
        VirtualFile vFile = file.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            vFile = ((VirtualFileWindow)vFile).getDelegate();
        }
        Project project = file.getProject();
        if (vFile == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInSourceContent(vFile)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "processFile"));
            }
            return runnable;
        }
        ArrayList<Pair<String, Boolean>> names = new ArrayList<Pair<String, Boolean>>();
        HashSet demandedForNested = new HashSet();
        JavaFxImportsOptimizer.collectNamesToImport(names, (Collection<String>)demandedForNested, (XmlFile)file);
        Collections.sort(names, (o1, o2) -> StringUtil.compare((String)((String)o1.first), (String)((String)o2.first), (boolean)true));
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        List sortedNames = ImportHelper.sortItemsAccordingToSettings(names, (CodeStyleSettings)settings);
        HashMap onDemand = new HashMap();
        ImportHelper.collectOnDemandImports((List)sortedNames, (CodeStyleSettings)settings, (Map)onDemand);
        for (String s : demandedForNested) {
            onDemand.put(s, false);
        }
        HashSet imported = new HashSet();
        ArrayList<String> imports = new ArrayList<String>();
        for (Pair pair : sortedNames) {
            String qName = (String)pair.first;
            String packageName = StringUtil.getPackageName((String)qName);
            if (imported.contains(packageName) || imported.contains(qName)) continue;
            if (onDemand.containsKey(packageName)) {
                imported.add(packageName);
                imports.add("<?import " + packageName + ".*?>");
                continue;
            }
            imported.add(qName);
            imports.add("<?import " + qName + "?>");
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)file.getProject());
        XmlFile dummyFile = (XmlFile)factory.createFileFromText("_Dummy_.fxml", (FileType)StdFileTypes.XML, (CharSequence)StringUtil.join(imports, (String)"\n"));
        XmlDocument document = dummyFile.getDocument();
        XmlProlog xmlProlog = newImportList = document != null ? document.getProlog() : null;
        if (newImportList == null) {
            Runnable runnable = EmptyRunnable.getInstance();
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "processFile"));
            }
            return runnable;
        }
        Runnable runnable = () -> {
            XmlProlog prolog;
            XmlDocument xmlDocument = ((XmlFile)file).getDocument();
            XmlProlog xmlProlog = prolog = xmlDocument != null ? xmlDocument.getProlog() : null;
            if (prolog != null) {
                Collection instructions = PsiTreeUtil.findChildrenOfType((PsiElement)prolog, XmlProcessingInstruction.class);
                for (XmlProcessingInstruction instruction : instructions) {
                    ASTNode node = instruction.getNode();
                    ASTNode nameNode = node.findChildByType(XmlTokenType.XML_NAME);
                    if (nameNode == null || !nameNode.getText().equals("import")) continue;
                    instruction.delete();
                }
                prolog.add((PsiElement)newImportList);
            } else {
                document.addBefore((PsiElement)newImportList, (PsiElement)document.getRootTag());
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "processFile"));
        }
        return runnable;
    }

    private static void collectNamesToImport(final @NotNull Collection<Pair<String, Boolean>> names, final @NotNull Collection<String> demandedForNested, @NotNull XmlFile file) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "collectNamesToImport"));
        }
        if (demandedForNested == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "demandedForNested", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "collectNamesToImport"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer", "collectNamesToImport"));
        }
        file.accept((PsiElementVisitor)new JavaFxUsedClassesVisitor(){

            @Override
            protected void appendClassName(String fqn) {
                names.add(Pair.create((Object)fqn, (Object)false));
            }

            @Override
            protected void appendDemandedPackageName(@NotNull String packageName) {
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer$1", "appendDemandedPackageName"));
                }
                demandedForNested.add(packageName);
            }
        });
    }

    public static abstract class JavaFxUsedClassesVisitor
    extends XmlRecursiveElementVisitor {
        public void visitXmlProlog(XmlProlog prolog) {
        }

        public void visitXmlProcessingInstruction(XmlProcessingInstruction processingInstruction) {
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (descriptor instanceof JavaFxStaticSetterAttributeDescriptor) {
                PsiElement declaration = descriptor.getDeclaration();
                if (declaration instanceof PsiMember) {
                    this.appendClassName((PsiElement)((PsiMember)declaration).getContainingClass());
                }
            } else if (descriptor instanceof JavaFxRootTagDescriptor.RootTagTypeAttributeDescriptor) {
                this.appendClassName((PsiElement)JavaFxPsiUtil.findPsiClass(attribute.getValue(), (PsiElement)attribute));
            }
        }

        public void visitXmlTag(XmlTag tag) {
            PsiElement declaration;
            super.visitXmlTag(tag);
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor instanceof JavaFxClassTagDescriptorBase) {
                this.appendClassName(descriptor.getDeclaration());
            } else if (descriptor instanceof JavaFxPropertyTagDescriptor && ((JavaFxPropertyTagDescriptor)descriptor).isStatic() && (declaration = descriptor.getDeclaration()) instanceof PsiMember) {
                this.appendClassName((PsiElement)((PsiMember)declaration).getContainingClass());
            }
        }

        private void appendClassName(PsiElement declaration) {
            if (declaration instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)declaration;
                String ownerClassQN = JavaFxUsedClassesVisitor.getTopmostOwnerClassQualifiedName(psiClass);
                if (ownerClassQN != null) {
                    this.appendClassName(ownerClassQN);
                    String ownerClassPackageName = StringUtil.getPackageName((String)ownerClassQN);
                    if (!StringUtil.isEmpty((String)ownerClassPackageName)) {
                        this.appendDemandedPackageName(ownerClassPackageName);
                    }
                } else {
                    String classQN = psiClass.getQualifiedName();
                    if (classQN != null) {
                        this.appendClassName(classQN);
                    }
                }
            }
        }

        @Nullable
        private static String getTopmostOwnerClassQualifiedName(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxImportsOptimizer$JavaFxUsedClassesVisitor", "getTopmostOwnerClassQualifiedName"));
            }
            PsiClass ownerClass = null;
            for (PsiClass aClass = psiClass.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
                ownerClass = aClass;
            }
            if (ownerClass != null) {
                return ownerClass.getQualifiedName();
            }
            return null;
        }

        protected abstract void appendClassName(String var1);

        protected abstract void appendDemandedPackageName(@NotNull String var1);
    }
}

