/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.uiDesigner.CaptionSelection;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import icons.UIDesignerIcons;

public final class DeleteAction
extends AnAction {
    public DeleteAction() {
        this.getTemplatePresentation().setIcon(UIDesignerIcons.DeleteCell);
    }

    public void actionPerformed(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        CaptionSelection selection = (CaptionSelection)CaptionSelection.DATA_KEY.getData(e.getDataContext());
        if (editor == null || selection == null || selection.getFocusedIndex() < 0) {
            return;
        }
        FormEditingUtil.deleteRowOrColumn(editor, selection.getContainer(), selection.getSelection(), selection.isRow());
        selection.getContainer().revalidate();
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        CaptionSelection selection = (CaptionSelection)CaptionSelection.DATA_KEY.getData(e.getDataContext());
        if (selection == null || selection.getContainer() == null) {
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        if (selection.getSelection().length > 1) {
            presentation.setText(!selection.isRow() ? UIDesignerBundle.message("action.delete.columns", new Object[0]) : UIDesignerBundle.message("action.delete.rows", new Object[0]));
        } else {
            presentation.setText(!selection.isRow() ? UIDesignerBundle.message("action.delete.column", new Object[0]) : UIDesignerBundle.message("action.delete.row", new Object[0]));
        }
        int minCellCount = selection.getContainer().getGridLayoutManager().getMinCellCount();
        if (selection.getContainer().getGridCellCount(selection.isRow()) - selection.getSelection().length < minCellCount) {
            presentation.setEnabled(false);
        } else if (selection.getFocusedIndex() < 0) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
    }
}

