/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PropertyStubElementType
extends ILightStubElementType<PropertyStub, Property> {
    public PropertyStubElementType() {
        super("PROPERTY", (Language)PropertiesElementTypes.LANG);
    }

    public Property createPsi(@NotNull PropertyStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/properties/parsing/PropertyStubElementType", "createPsi"));
        }
        return new PropertyImpl(stub, (IStubElementType)this);
    }

    @NotNull
    public PropertyStub createStub(@NotNull Property psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/properties/parsing/PropertyStubElementType", "createStub"));
        }
        PropertyStubImpl propertyStubImpl = new PropertyStubImpl(parentStub, psi.getKey());
        if (propertyStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertyStubElementType", "createStub"));
        }
        return propertyStubImpl;
    }

    @NotNull
    public String getExternalId() {
        if ("properties.prop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertyStubElementType", "getExternalId"));
        }
        return "properties.prop";
    }

    public void serialize(@NotNull PropertyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/properties/parsing/PropertyStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/properties/parsing/PropertyStubElementType", "serialize"));
        }
        dataStream.writeName(stub.getKey());
    }

    @NotNull
    public PropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/properties/parsing/PropertyStubElementType", "deserialize"));
        }
        StringRef ref = dataStream.readName();
        PropertyStubImpl propertyStubImpl = new PropertyStubImpl(parentStub, ref.getString());
        if (propertyStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertyStubElementType", "deserialize"));
        }
        return propertyStubImpl;
    }

    public void indexStub(@NotNull PropertyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/properties/parsing/PropertyStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/properties/parsing/PropertyStubElementType", "indexStub"));
        }
        sink.occurrence(PropertyKeyIndex.KEY, (Object)PropertyImpl.unescape(stub.getKey()));
    }

    public PropertyStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        LighterASTNode keyNode = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)PropertiesTokenTypes.KEY_CHARACTERS);
        String key = PropertyStubElementType.intern(tree.getCharTable(), keyNode);
        return new PropertyStubImpl(parentStub, key);
    }

    public static String intern(@NotNull CharTable table, @NotNull LighterASTNode node) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/lang/properties/parsing/PropertyStubElementType", "intern"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/properties/parsing/PropertyStubElementType", "intern"));
        }
        assert (node instanceof LighterASTTokenNode) : node;
        return table.intern(((LighterASTTokenNode)node).getText()).toString();
    }
}

