/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j;

import com.pty4j.WinSize;
import com.pty4j.unix.Pty;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.util.PtyUtil;
import com.pty4j.windows.CygwinPtyProcess;
import com.pty4j.windows.WinPtyProcess;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PtyProcess
extends Process {
    public abstract boolean isRunning();

    public abstract void setWinSize(WinSize var1);

    public abstract WinSize getWinSize() throws IOException;

    public static PtyProcess exec(String[] command) throws IOException {
        return PtyProcess.exec(command, (Map<String, String>)null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment) throws IOException {
        return PtyProcess.exec(command, environment, null, false, false, null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment, String workingDirectory) throws IOException {
        return PtyProcess.exec(command, environment, workingDirectory, false, false, null);
    }

    @Deprecated
    public static PtyProcess exec(String[] command, String[] environment) throws IOException {
        return PtyProcess.exec(command, environment, null, false);
    }

    @Deprecated
    public static PtyProcess exec(String[] command, String[] environment, String workingDirectory, boolean console) throws IOException {
        if (Platform.isWindows()) {
            return new WinPtyProcess(command, environment, workingDirectory, console);
        }
        return new UnixPtyProcess(command, environment, workingDirectory, new Pty(console), console ? new Pty() : null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment, String workingDirectory, boolean console) throws IOException {
        return PtyProcess.exec(command, environment, workingDirectory, console, false, null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment, String workingDirectory, boolean console, boolean cygwin, File logFile) throws IOException {
        if (Platform.isWindows()) {
            if (environment == null) {
                environment = new TreeMap<String, String>();
            }
            if (cygwin) {
                return new CygwinPtyProcess(command, environment, workingDirectory, logFile, console);
            }
            return new WinPtyProcess(command, Advapi32Util.getEnvironmentBlock(environment), workingDirectory, console);
        }
        return new UnixPtyProcess(command, PtyUtil.toStringArray(environment), workingDirectory, new Pty(console), console ? new Pty() : null);
    }
}

