/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AdvancedSettingsUI
implements SearchableConfigurable {
    private final Configuration.AdvancedConfiguration myConfiguration;
    private AdvancedSettingsPanel myPanel;
    private final Project myProject;

    public AdvancedSettingsUI(@NotNull Project project, Configuration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/AdvancedSettingsUI", "<init>"));
        }
        this.myProject = project;
        this.myConfiguration = configuration.getAdvancedConfiguration();
    }

    public JComponent createComponent() {
        this.myPanel = new AdvancedSettingsPanel();
        return this.myPanel.myRoot;
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    @Nls
    public String getDisplayName() {
        return "Advanced";
    }

    public String getHelpTopic() {
        return "reference.settings.injection.advanced";
    }

    @NotNull
    public String getId() {
        if ("IntelliLang.Advanced" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI", "getId"));
        }
        return "IntelliLang.Advanced";
    }

    public class AdvancedSettingsPanel {
        private JPanel myRoot;
        private JRadioButton myNoInstrumentation;
        private JRadioButton myAssertInstrumentation;
        private JRadioButton myExceptionInstrumentation;
        private JPanel myLanguageAnnotationPanel;
        private JPanel myPatternAnnotationPanel;
        private JPanel mySubstAnnotationPanel;
        private JRadioButton myDfaOff;
        private JRadioButton myAnalyzeReferences;
        private JRadioButton myUseDfa;
        private JRadioButton myLookForAssignments;
        private JCheckBox myIncludeUncomputableOperandsAsCheckBox;
        private JCheckBox mySourceModificationAllowedCheckBox;
        private final ReferenceEditorWithBrowseButton myAnnotationField;
        private final ReferenceEditorWithBrowseButton myPatternField;
        private final ReferenceEditorWithBrowseButton mySubstField;

        public AdvancedSettingsPanel() {
            this.$$$setupUI$$$();
            this.myAnnotationField = new ReferenceEditorWithBrowseButton(null, AdvancedSettingsUI.this.myProject, s -> PsiUtilEx.createDocument(s, AdvancedSettingsUI.this.myProject), AdvancedSettingsUI.this.myConfiguration.getLanguageAnnotationClass());
            this.myAnnotationField.addActionListener((ActionListener)new BrowseClassListener(AdvancedSettingsUI.this.myProject, this.myAnnotationField));
            this.myAnnotationField.setEnabled(!AdvancedSettingsUI.this.myProject.isDefault());
            this.addField(this.myLanguageAnnotationPanel, this.myAnnotationField);
            this.myPatternField = new ReferenceEditorWithBrowseButton(null, AdvancedSettingsUI.this.myProject, s -> PsiUtilEx.createDocument(s, AdvancedSettingsUI.this.myProject), AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass());
            this.myPatternField.addActionListener((ActionListener)new BrowseClassListener(AdvancedSettingsUI.this.myProject, this.myPatternField));
            this.myPatternField.setEnabled(!AdvancedSettingsUI.this.myProject.isDefault());
            this.addField(this.myPatternAnnotationPanel, this.myPatternField);
            this.mySubstField = new ReferenceEditorWithBrowseButton(null, AdvancedSettingsUI.this.myProject, s -> PsiUtilEx.createDocument(s, AdvancedSettingsUI.this.myProject), AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass());
            this.mySubstField.addActionListener((ActionListener)new BrowseClassListener(AdvancedSettingsUI.this.myProject, this.mySubstField));
            this.mySubstField.setEnabled(!AdvancedSettingsUI.this.myProject.isDefault());
            this.addField(this.mySubstAnnotationPanel, this.mySubstField);
        }

        private void addField(JPanel panel, ReferenceEditorWithBrowseButton field) {
            Component component;
            panel.add((Component)field, "Center");
            Component[] components = panel.getParent().getComponents();
            int index = Arrays.asList(components).indexOf(panel);
            if (index > 0 && (component = components[index - 1]) instanceof JLabel) {
                ((JLabel)component).setLabelFor((Component)field);
            }
        }

        public boolean isModified() {
            if (this.getInstrumentation() != AdvancedSettingsUI.this.myConfiguration.getInstrumentation()) {
                return true;
            }
            if (!this.myAnnotationField.getText().equals(AdvancedSettingsUI.this.myConfiguration.getLanguageAnnotationClass())) {
                return true;
            }
            if (!this.myPatternField.getText().equals(AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass())) {
                return true;
            }
            if (!this.mySubstField.getText().equals(AdvancedSettingsUI.this.myConfiguration.getSubstAnnotationClass())) {
                return true;
            }
            if (!AdvancedSettingsUI.this.myConfiguration.getDfaOption().equals((Object)this.getDfaOption())) {
                return true;
            }
            if (AdvancedSettingsUI.this.myConfiguration.isIncludeUncomputablesAsLiterals() != this.myIncludeUncomputableOperandsAsCheckBox.isSelected()) {
                return true;
            }
            return AdvancedSettingsUI.this.myConfiguration.isSourceModificationAllowed() != this.mySourceModificationAllowedCheckBox.isSelected();
        }

        @NotNull
        private Configuration.InstrumentationType getInstrumentation() {
            if (this.myNoInstrumentation.isSelected()) {
                Configuration.InstrumentationType instrumentationType = Configuration.InstrumentationType.NONE;
                if (instrumentationType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getInstrumentation"));
                }
                return instrumentationType;
            }
            if (this.myAssertInstrumentation.isSelected()) {
                Configuration.InstrumentationType instrumentationType = Configuration.InstrumentationType.ASSERT;
                if (instrumentationType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getInstrumentation"));
                }
                return instrumentationType;
            }
            if (this.myExceptionInstrumentation.isSelected()) {
                Configuration.InstrumentationType instrumentationType = Configuration.InstrumentationType.EXCEPTION;
                if (instrumentationType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getInstrumentation"));
                }
                return instrumentationType;
            }
            assert (false);
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getInstrumentation"));
            }
            return null;
        }

        public void apply() throws ConfigurationException {
            AdvancedSettingsUI.this.myConfiguration.setInstrumentationType(this.getInstrumentation());
            AdvancedSettingsUI.this.myConfiguration.setLanguageAnnotation(this.myAnnotationField.getText());
            AdvancedSettingsUI.this.myConfiguration.setPatternAnnotation(this.myPatternField.getText());
            AdvancedSettingsUI.this.myConfiguration.setSubstAnnotation(this.mySubstField.getText());
            AdvancedSettingsUI.this.myConfiguration.setDfaOption(this.getDfaOption());
            AdvancedSettingsUI.this.myConfiguration.setIncludeUncomputablesAsLiterals(this.myIncludeUncomputableOperandsAsCheckBox.isSelected());
            AdvancedSettingsUI.this.myConfiguration.setSourceModificationAllowed(this.mySourceModificationAllowedCheckBox.isSelected());
        }

        @NotNull
        private Configuration.DfaOption getDfaOption() {
            if (this.myDfaOff.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.OFF;
                if (dfaOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getDfaOption"));
                }
                return dfaOption;
            }
            if (this.myAnalyzeReferences.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.RESOLVE;
                if (dfaOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getDfaOption"));
                }
                return dfaOption;
            }
            if (this.myLookForAssignments.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.ASSIGNMENTS;
                if (dfaOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getDfaOption"));
                }
                return dfaOption;
            }
            if (this.myUseDfa.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.DFA;
                if (dfaOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getDfaOption"));
                }
                return dfaOption;
            }
            Configuration.DfaOption dfaOption = Configuration.DfaOption.OFF;
            if (dfaOption == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "getDfaOption"));
            }
            return dfaOption;
        }

        public void reset() {
            this.myAnnotationField.setText(AdvancedSettingsUI.this.myConfiguration.getLanguageAnnotationClass());
            this.myPatternField.setText(AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass());
            this.mySubstField.setText(AdvancedSettingsUI.this.myConfiguration.getSubstAnnotationClass());
            this.myNoInstrumentation.setSelected(AdvancedSettingsUI.this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.NONE);
            this.myAssertInstrumentation.setSelected(AdvancedSettingsUI.this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.ASSERT);
            this.myExceptionInstrumentation.setSelected(AdvancedSettingsUI.this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.EXCEPTION);
            this.setDfaOption(AdvancedSettingsUI.this.myConfiguration.getDfaOption());
            this.myIncludeUncomputableOperandsAsCheckBox.setSelected(AdvancedSettingsUI.this.myConfiguration.isIncludeUncomputablesAsLiterals());
            this.mySourceModificationAllowedCheckBox.setSelected(AdvancedSettingsUI.this.myConfiguration.isSourceModificationAllowed());
        }

        private void setDfaOption(@NotNull Configuration.DfaOption dfaOption) {
            if (dfaOption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaOption", "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel", "setDfaOption"));
            }
            switch (dfaOption) {
                case OFF: {
                    this.myDfaOff.setSelected(true);
                    break;
                }
                case RESOLVE: {
                    this.myAnalyzeReferences.setSelected(true);
                    break;
                }
                case ASSIGNMENTS: {
                    this.myLookForAssignments.setSelected(true);
                    break;
                }
                case DFA: {
                    this.myUseDfa.setSelected(true);
                }
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JRadioButton jRadioButton3;
            JRadioButton jRadioButton4;
            JRadioButton jRadioButton5;
            JRadioButton jRadioButton6;
            JRadioButton jRadioButton7;
            JPanel jPanel;
            JPanel jPanel2;
            JPanel jPanel3;
            JPanel jPanel4;
            this.myRoot = jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Annotation Classes", (int)0, (int)0, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Language annotation class");
            jLabel.setDisplayedMnemonic('L');
            jLabel.setDisplayedMnemonicIndex(0);
            jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLanguageAnnotationPanel = jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout(0, 0));
            jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Pattern annotation class");
            jLabel2.setDisplayedMnemonic('P');
            jLabel2.setDisplayedMnemonicIndex(0);
            jPanel5.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPatternAnnotationPanel = jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout(0, 0));
            jPanel5.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("Substitution annotation class");
            jLabel3.setDisplayedMnemonic('S');
            jLabel3.setDisplayedMnemonicIndex(0);
            jPanel5.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.mySubstAnnotationPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel5.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout(0, 0));
            jPanel.add((Component)jPanel6, "Center");
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Runtime Pattern Validation", (int)0, (int)0, null, null));
            this.myNoInstrumentation = jRadioButton7 = new JRadioButton();
            jRadioButton7.setText("No runtime instrumentation");
            jRadioButton7.setMnemonic('N');
            jRadioButton7.setDisplayedMnemonicIndex(0);
            jPanel7.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAssertInstrumentation = jRadioButton6 = new JRadioButton();
            jRadioButton6.setText("Instrument with assertions");
            jRadioButton6.setMnemonic('I');
            jRadioButton6.setDisplayedMnemonicIndex(0);
            jPanel7.add((Component)jRadioButton6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myExceptionInstrumentation = jRadioButton5 = new JRadioButton();
            jRadioButton5.setText("Instrument with IllegalArgumentException");
            jRadioButton5.setMnemonic('W');
            jRadioButton5.setDisplayedMnemonicIndex(11);
            jPanel7.add((Component)jRadioButton5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Performance", (int)0, (int)0, null, null));
            this.myDfaOff = jRadioButton4 = new JRadioButton();
            jRadioButton4.setText("Do not analyze anything (fast)");
            jRadioButton4.setMnemonic('D');
            jRadioButton4.setDisplayedMnemonicIndex(0);
            jPanel8.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAnalyzeReferences = jRadioButton3 = new JRadioButton();
            jRadioButton3.setText("Analyze references");
            jRadioButton3.setMnemonic('R');
            jRadioButton3.setDisplayedMnemonicIndex(8);
            jPanel8.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myLookForAssignments = jRadioButton2 = new JRadioButton();
            jRadioButton2.setText("Look for variable assignments");
            jRadioButton2.setMnemonic('V');
            jRadioButton2.setDisplayedMnemonicIndex(9);
            jPanel8.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myUseDfa = jRadioButton = new JRadioButton();
            jRadioButton.setSelected(false);
            jRadioButton.setText("Use dataflow analysis (slow) ");
            jRadioButton.setMnemonic('U');
            jRadioButton.setDisplayedMnemonicIndex(0);
            jPanel8.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myIncludeUncomputableOperandsAsCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Convert undefined operands to text in concatenations");
            jCheckBox2.setMnemonic('T');
            jCheckBox2.setDisplayedMnemonicIndex(30);
            jPanel4.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.mySourceModificationAllowedCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Add @Language annotation or comment if needed");
            jPanel4.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel4.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton7);
            buttonGroup.add(jRadioButton6);
            buttonGroup.add(jRadioButton5);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton4);
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRoot;
        }
    }

    private static class BrowseClassListener
    implements ActionListener {
        private final Project myProject;
        private final ReferenceEditorWithBrowseButton myField;

        private BrowseClassListener(Project project, ReferenceEditorWithBrowseButton annotationField) {
            this.myProject = project;
            this.myField = annotationField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.myProject);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myField.getText(), scope);
            TreeClassChooser chooser = factory.createNoInnerClassesScopeChooser("Select Annotation Class", scope, new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.isAnnotationType();
                }
            }, aClass);
            chooser.showDialog();
            PsiClass psiClass = chooser.getSelected();
            if (psiClass != null) {
                this.myField.setText(psiClass.getQualifiedName());
            }
        }
    }
}

