/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.List;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLocallyAvailableResourceCandidates
implements LocallyAvailableResourceCandidates {
    private final Factory<List<File>> filesFactory;
    private List<File> files;

    public LazyLocallyAvailableResourceCandidates(Factory<List<File>> filesFactory) {
        this.filesFactory = filesFactory;
    }

    protected List<File> getFiles() {
        if (this.files == null) {
            this.files = (List)this.filesFactory.create();
        }
        return this.files;
    }

    @Override
    public boolean isNone() {
        return this.getFiles().isEmpty();
    }

    @Override
    public LocallyAvailableResource findByHashValue(HashValue targetHash) {
        for (File file : this.getFiles()) {
            HashValue thisHash = HashUtil.sha1((File)file);
            if (!thisHash.equals((Object)targetHash)) continue;
            return new DefaultLocallyAvailableResource(file, thisHash);
        }
        return null;
    }
}

