/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.interpreter;

import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;

public class Util {
    private static final String[][] runtime_exceptions = new String[][]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException", "java/lang/ArrayStoreException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, {"java/lang/NullPointerException", "java/lang/ArrayIndexOutOfBoundsException"}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {"java/lang/ArithmeticException"}, {"java/lang/ArithmeticException"}, null, null, {"java/lang/ArithmeticException"}, {"java/lang/ArithmeticException"}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {"java/lang/IllegalMonitorStateException"}, {"java/lang/IllegalMonitorStateException"}, {"java/lang/IllegalMonitorStateException"}, {"java/lang/IllegalMonitorStateException"}, {"java/lang/IllegalMonitorStateException"}, {"java/lang/IllegalMonitorStateException"}, null, null, {"java/lang/NullPointerException"}, {"java/lang/NullPointerException"}, {"java/lang/NullPointerException", "java/lang/AbstractMethodError", "java/lang/UnsatisfiedLinkError"}, {"java/lang/NullPointerException", "java/lang/UnsatisfiedLinkError"}, {"java/lang/UnsatisfiedLinkError"}, {"java/lang/NullPointerException", "java/lang/IncompatibleClassChangeError", "java/lang/IllegalAccessError", "java/lang/java/lang/AbstractMethodError", "java/lang/UnsatisfiedLinkError"}, null, null, {"java/lang/NegativeArraySizeException"}, {"java/lang/NegativeArraySizeException"}, {"java/lang/NullPointerException"}, {"java/lang/NullPointerException", "java/lang/IllegalMonitorStateException"}, {"java/lang/ClassCastException"}, null, {"java/lang/NullPointerException"}, {"java/lang/NullPointerException", "java/lang/IllegalMonitorStateException"}, null, {"java/lang/NegativeArraySizeException"}, null, null, null, null};

    public static boolean instanceOf(StructContext context, String valclass, String refclass) {
        if (valclass.equals(refclass)) {
            return true;
        }
        StructClass cl = context.getClass(valclass);
        if (cl == null) {
            return false;
        }
        if (cl.superClass != null && Util.instanceOf(context, cl.superClass.getString(), refclass)) {
            return true;
        }
        int[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String intfc = cl.getPool().getPrimitiveConstant(interfaces[i]).getString();
            if (!Util.instanceOf(context, intfc, refclass)) continue;
            return true;
        }
        return false;
    }

    public static String[] getRuntimeExceptions(Instruction instr) {
        return runtime_exceptions[instr.opcode];
    }
}

