/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class CallTransformer {
    private CallTransformer() {
    }

    public static Call stripCallArguments(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "stripCallArguments"));
        }
        return new DelegatingCall(call){

            @Override
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getValueArguments"));
                }
                return list2;
            }

            @NotNull
            public List<LambdaArgument> getFunctionLiteralArguments() {
                List<LambdaArgument> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getFunctionLiteralArguments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getTypeArguments"));
                }
                return list2;
            }

            @Override
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtExpression calleeExpression = this.getCalleeExpression();
                assert (calleeExpression != null) : "No callee expression: " + this.getCallElement().getText();
                KtExpression ktExpression = calleeExpression;
                if (ktExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getCallElement"));
                }
                return ktExpression;
            }
        };
    }

    public static Call stripReceiver(@NotNull Call variableCall) {
        if (variableCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableCall", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "stripReceiver"));
        }
        return new DelegatingCall(variableCall){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getExplicitReceiver() {
                return null;
            }
        };
    }

    public static class CallForImplicitInvoke
    extends DelegatingCall {
        private final Call outerCall;
        private final Receiver explicitExtensionReceiver;
        private final ExpressionReceiver calleeExpressionAsDispatchReceiver;
        private final KtSimpleNameExpression fakeInvokeExpression;
        public final boolean itIsVariableAsFunctionCall;

        public CallForImplicitInvoke(@Nullable Receiver explicitExtensionReceiver, @NotNull ExpressionReceiver calleeExpressionAsDispatchReceiver, @NotNull Call call, boolean functionCall2) {
            if (calleeExpressionAsDispatchReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpressionAsDispatchReceiver", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "<init>"));
            }
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "<init>"));
            }
            super(call);
            this.outerCall = call;
            this.explicitExtensionReceiver = explicitExtensionReceiver;
            this.calleeExpressionAsDispatchReceiver = calleeExpressionAsDispatchReceiver;
            this.fakeInvokeExpression = (KtSimpleNameExpression)KtPsiFactoryKt.KtPsiFactory((PsiElement)call.getCallElement()).createExpression(OperatorNameConventions.INVOKE.asString());
            this.itIsVariableAsFunctionCall = functionCall2;
        }

        @Override
        @Nullable
        public ASTNode getCallOperationNode() {
            return this.explicitExtensionReceiver != null ? super.getCallOperationNode() : null;
        }

        @Override
        @Nullable
        public Receiver getExplicitReceiver() {
            return this.explicitExtensionReceiver;
        }

        @Override
        @NotNull
        public ExpressionReceiver getDispatchReceiver() {
            ExpressionReceiver expressionReceiver = this.calleeExpressionAsDispatchReceiver;
            if (expressionReceiver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getDispatchReceiver"));
            }
            return expressionReceiver;
        }

        @Override
        public KtExpression getCalleeExpression() {
            return this.fakeInvokeExpression;
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = Call.CallType.INVOKE;
            if (callType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getCallType"));
            }
            return callType;
        }

        @NotNull
        public Call getOuterCall() {
            Call call = this.outerCall;
            if (call == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getOuterCall"));
            }
            return call;
        }
    }
}

