/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

public final class AnnotationsUtils {
    private static final String JS_NAME = "kotlin.js.JsName";

    private AnnotationsUtils() {
    }

    public static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor2, annotation2) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation2);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value2 = constant.getValue();
        assert (value2 instanceof String) : "Native function annotation should have one String parameter";
        return (String)value2;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation2)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation2);
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.Companion.getWITH_CUSTOM_NAME()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
            String name2 = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, annotation2);
            if (name2 == null) {
                name2 = AnnotationsUtils.getJsName(descriptor2);
            }
            return name2 != null ? name2 : descriptor2.getName().asString();
        }
        return AnnotationsUtils.getJsName(descriptor2);
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor2, annotation2.getFqName());
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        AnnotationWithTarget annotationWithTarget = Annotations.Companion.findAnyAnnotation(descriptor2.getAnnotations(), fqName2);
        return annotationWithTarget != null ? annotationWithTarget.getAnnotation() : null;
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "isNativeObject"));
        }
        if (AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.NATIVE)) {
            return true;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyAccessorDescriptor accessor = (PropertyAccessorDescriptor)descriptor2;
            return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)accessor.getCorrespondingProperty(), PredefinedAnnotation.NATIVE);
        }
        return false;
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "isLibraryObject"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.LIBRARY);
    }

    @Nullable
    public static String getJsName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getJsName"));
        }
        AnnotationDescriptor annotation2 = AnnotationsUtils.getJsNameAnnotation(descriptor2);
        if (annotation2 == null) {
            return null;
        }
        ConstantValue<?> value2 = annotation2.getAllValueArguments().values().iterator().next();
        assert (value2 != null) : "JsName annotation should always declare string parameter";
        Object result2 = value2.getValue();
        assert (result2 instanceof String) : "Parameter of JsName annotation should be string";
        return (String)result2;
    }

    @Nullable
    public static AnnotationDescriptor getJsNameAnnotation(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getJsNameAnnotation"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor2, new FqName(JS_NAME));
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "isPredefinedObject"));
        }
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2.getFqName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (AnnotationsUtils.getAnnotationByName(descriptor2, fqName2) != null) {
            return true;
        }
        ClassDescriptor containingClass = DescriptorUtils.getContainingClass(descriptor2);
        return containingClass != null && AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)containingClass, fqName2);
    }

    public static boolean hasJsNameInAccessors(@NotNull PropertyDescriptor property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasJsNameInAccessors"));
        }
        for (PropertyAccessorDescriptor accessor : property2.getAccessors()) {
            if (AnnotationsUtils.getJsName(accessor) == null) continue;
            return true;
        }
        return false;
    }
}

