/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.codeInsight.highlighting.JavaReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReadWriteAccessDetector$WhenMappings;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReadWriteAccessDetector;", "Lcom/intellij/codeInsight/highlighting/ReadWriteAccessDetector;", "()V", "getExpressionAccess", "Lcom/intellij/codeInsight/highlighting/ReadWriteAccessDetector$Access;", "expression", "Lcom/intellij/psi/PsiElement;", "getReferenceAccess", "referencedElement", "reference", "Lcom/intellij/psi/PsiReference;", "isDeclarationWriteAccess", "", "element", "isReadWriteAccessible", "idea-analysis"})
public final class KotlinReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof KtVariableDeclaration || element2 instanceof KtParameter;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.isReadWriteAccessible(element2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference2) {
        Intrinsics.checkParameterIsNotNull((Object)referencedElement, (String)"referencedElement");
        Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
        if (!this.isReadWriteAccessible(referencedElement)) {
            return ReadWriteAccessDetector.Access.Read;
        }
        PsiElement refTarget = reference2.resolve();
        if (refTarget instanceof KtLightMethod) {
            KtNamedDeclaration ktNamedDeclaration;
            KtDeclaration origin = (KtDeclaration)((KtLightMethod)refTarget).getKotlinOrigin();
            Object object = origin;
            if (object instanceof KtPropertyAccessor) {
                void $receiver$iv;
                PsiElement psiElement = origin;
                ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtProperty.class, (boolean)false);
            } else if (object instanceof KtProperty || object instanceof KtParameter) {
                KtDeclaration ktDeclaration = origin;
                if (ktDeclaration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                }
                ktNamedDeclaration = (KtNamedDeclaration)ktDeclaration;
            } else {
                ktNamedDeclaration = null;
            }
            if (ktNamedDeclaration == null) {
                return ReadWriteAccessDetector.Access.ReadWrite;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            object = ((KtLightMethod)refTarget).getName();
            String string = declaration.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)object, (Object)JvmAbi.getterName(string))) {
                return ReadWriteAccessDetector.Access.Read;
            }
            String string2 = declaration.getName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)object, (Object)JvmAbi.setterName(string2))) {
                return ReadWriteAccessDetector.Access.Write;
            }
            return ReadWriteAccessDetector.Access.ReadWrite;
        }
        PsiElement psiElement = reference2.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"reference.element");
        return this.getExpressionAccess(psiElement);
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression2) {
        ReadWriteAccessDetector.Access access;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (!(expression2 instanceof KtExpression)) {
            ReadWriteAccessDetector.Access access2 = new JavaReadWriteAccessDetector().getExpressionAccess(expression2);
            Intrinsics.checkExpressionValueIsNotNull((Object)access2, (String)"JavaReadWriteAccessDetec\u2026ressionAccess(expression)");
            return access2;
        }
        switch (KotlinReadWriteAccessDetector$WhenMappings.$EnumSwitchMapping$0[ReferenceUtilKt.readWriteAccess((KtExpression)expression2, true).ordinal()]) {
            case 1: {
                access = ReadWriteAccessDetector.Access.Read;
                break;
            }
            case 2: {
                access = ReadWriteAccessDetector.Access.Write;
                break;
            }
            case 3: {
                access = ReadWriteAccessDetector.Access.ReadWrite;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return access;
    }
}

