/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "Companion", "idea"})
public final class ReplaceInfixOrOperatorCallFix
extends KotlinQuickFixAction<KtExpression> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Replace with safe (?.) call";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)file2);
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression instanceof KtArrayAccessExpression) {
            KtBinaryExpression assignment;
            KtBinaryExpression ktBinaryExpression = assignment = KtPsiUtilKt.getAssignmentByLHS((KtExpression)this.getElement());
            KtExpression right = ktBinaryExpression != null ? ktBinaryExpression.getRight() : null;
            KtExpression ktExpression2 = ((KtArrayAccessExpression)this.getElement()).getArrayExpression();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression arrayExpression = ktExpression2;
            if (assignment != null) {
                if (right == null) {
                    return;
                }
                Object[] objectArray = new Object[3];
                KtExpression ktExpression3 = arrayExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"arrayExpression");
                objectArray[0] = ktExpression3;
                objectArray[1] = CollectionsKt.joinToString$default((Iterable)((KtArrayAccessExpression)this.getElement()).getIndexExpressions(), (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.1.INSTANCE, (int)30, null);
                objectArray[2] = right;
                KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0?.set($1, $2)", objectArray);
                assignment.replace((PsiElement)newExpression2);
            } else {
                Object[] objectArray = new Object[2];
                KtExpression ktExpression4 = arrayExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"arrayExpression");
                objectArray[0] = ktExpression4;
                objectArray[1] = CollectionsKt.joinToString$default((Iterable)((KtArrayAccessExpression)this.getElement()).getIndexExpressions(), (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.2.INSTANCE, (int)30, null);
                KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0?.get($1)", objectArray);
                ((KtArrayAccessExpression)this.getElement()).replace((PsiElement)newExpression3);
            }
        } else if (ktExpression instanceof KtCallExpression) {
            Object[] objectArray = new Object[2];
            KtExpression ktExpression5 = ((KtCallExpression)this.getElement()).getCalleeExpression();
            if (ktExpression5 == null) {
                return;
            }
            objectArray[0] = ktExpression5;
            objectArray[1] = CollectionsKt.joinToString$default((Iterable)((KtCallExpression)this.getElement()).getValueArguments(), (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.3.INSTANCE, (int)30, null);
            KtExpression newExpression4 = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0?.invoke($1)", objectArray);
            ((KtCallExpression)this.getElement()).replace((PsiElement)newExpression4);
        } else if (ktExpression instanceof KtBinaryExpression) {
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)this.getElement()).getOperationToken(), (Object)((Object)KtTokens.IDENTIFIER))) {
                Object[] objectArray = new Object[3];
                KtExpression ktExpression6 = ((KtBinaryExpression)this.getElement()).getLeft();
                if (ktExpression6 == null) {
                    return;
                }
                objectArray[0] = ktExpression6;
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)this.getElement()).getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                objectArray[1] = ktOperationReferenceExpression;
                KtExpression ktExpression7 = ((KtBinaryExpression)this.getElement()).getRight();
                if (ktExpression7 == null) {
                    return;
                }
                objectArray[2] = ktExpression7;
                KtExpression newExpression5 = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0?.$1($2)", objectArray);
                ((KtBinaryExpression)this.getElement()).replace((PsiElement)newExpression5);
            } else {
                KtSimpleNameExpression nameExpression2 = (KtSimpleNameExpression)OperatorToFunctionIntention.Companion.convert((KtExpression)this.getElement()).getSecond();
                PsiElement psiElement = nameExpression2.getParent();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                }
                KtCallExpression callExpression2 = (KtCallExpression)psiElement;
                PsiElement psiElement2 = callExpression2.getParent();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
                }
                KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)psiElement2;
                KtExpression safeExpression = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0?.$1", qualifiedExpression.getReceiverExpression(), callExpression2);
                qualifiedExpression.replace((PsiElement)safeExpression);
            }
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public ReplaceInfixOrOperatorCallFix(@NotNull KtExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement expression2 = diagnostic.getPsiElement();
            if (expression2 instanceof KtArrayAccessExpression) {
                if (((KtArrayAccessExpression)expression2).getArrayExpression() == null) {
                    return null;
                }
                KtExpression ktExpression = (KtExpression)expression2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression");
                return new ReplaceInfixOrOperatorCallFix(ktExpression);
            }
            PsiElement parent2 = expression2.getParent();
            PsiElement psiElement = parent2;
            return psiElement instanceof KtBinaryExpression ? (IntentionAction)(((KtBinaryExpression)parent2).getLeft() == null || ((KtBinaryExpression)parent2).getRight() == null ? (ReplaceInfixOrOperatorCallFix)null : (CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.COMPARISON_OPERATIONS), (Object)((KtBinaryExpression)parent2).getOperationToken()) ? (ReplaceInfixOrOperatorCallFix)null : new ReplaceInfixOrOperatorCallFix((KtExpression)parent2))) : (psiElement instanceof KtCallExpression ? (IntentionAction)(((KtCallExpression)parent2).getCalleeExpression() == null ? (ReplaceInfixOrOperatorCallFix)null : (((KtCallExpression)parent2).getParent() instanceof KtQualifiedExpression ? (ReplaceInfixOrOperatorCallFix)null : new ReplaceInfixOrOperatorCallFix((KtExpression)parent2))) : (IntentionAction)null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

