/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\"\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "typeContainsError", "", "typePresentation", "", "typeSourceCode", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "variablePresentation", "ComponentFunctionReturnTypeMismatchFactory", "ForOverridden", "OnType", "PropertyOrReturnTypeMismatchOnOverrideFactory", "idea"})
public class ChangeVariableTypeFix
extends KotlinQuickFixAction<KtVariableDeclaration> {
    private final boolean typeContainsError;
    private final String typePresentation;
    private final String typeSourceCode;

    @Nullable
    public String variablePresentation() {
        String name2 = ((KtVariableDeclaration)this.getElement()).getName();
        if (name2 != null) {
            ClassDescriptor container2;
            Object object;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor((KtDeclaration)this.getElement()).getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            String containerName2 = (object = (container2 = (ClassDescriptor)declarationDescriptor)) != null && (object = object.getName()) != null && (object = (Name)AddToStdlibKt.check(object, variablePresentation.containerName.1.INSTANCE)) != null ? ((Name)object).asString() : null;
            return containerName2 != null ? "'" + containerName2 + "." + name2 + "'" : "'" + name2 + "'";
        }
        return null;
    }

    @NotNull
    public String getText() {
        String variablePresentation2 = this.variablePresentation();
        if (variablePresentation2 != null) {
            return "Change type of " + variablePresentation2 + " to '" + this.typePresentation + "'";
        }
        return "Change type to '" + this.typePresentation + "'";
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("change.type.family", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return !this.typeContainsError && super.isAvailable(project, editor, file2);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)file2);
        boolean bl = ((KtVariableDeclaration)this.getElement()).getNameIdentifier() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "ChangeVariableTypeFix applied to variable without name";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtTypeReference replacingTypeReference = psiFactory.createType(this.typeSourceCode);
        ArrayList<KtTypeReference> toShorten = new ArrayList<KtTypeReference>();
        KtTypeReference ktTypeReference = ((KtVariableDeclaration)this.getElement()).setTypeReference(replacingTypeReference);
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        toShorten.add(ktTypeReference);
        if (this.getElement() instanceof KtProperty) {
            KtTypeReference setterParameterTypeRef;
            KtDeclarationStub ktDeclarationStub;
            KtTypeReference getterReturnTypeRef;
            KtPropertyAccessor ktPropertyAccessor = ((KtProperty)this.getElement()).getGetter();
            KtTypeReference ktTypeReference2 = getterReturnTypeRef = ktPropertyAccessor != null ? ktPropertyAccessor.getReturnTypeReference() : null;
            if (getterReturnTypeRef != null) {
                PsiElement psiElement = getterReturnTypeRef.replace((PsiElement)replacingTypeReference);
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
                }
                toShorten.add((KtTypeReference)psiElement);
            }
            KtTypeReference ktTypeReference3 = (ktDeclarationStub = ((KtProperty)this.getElement()).getSetter()) != null && (ktDeclarationStub = ((KtPropertyAccessor)ktDeclarationStub).getParameter()) != null ? ((KtParameter)ktDeclarationStub).getTypeReference() : (setterParameterTypeRef = null);
            if (setterParameterTypeRef != null) {
                PsiElement psiElement = setterParameterTypeRef.replace((PsiElement)replacingTypeReference);
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
                }
                toShorten.add((KtTypeReference)psiElement);
            }
        }
        ShortenReferences.process$default(ShortenReferences.DEFAULT, toShorten, null, 2, null);
    }

    public ChangeVariableTypeFix(@NotNull KtVariableDeclaration element2, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element2);
        this.typeContainsError = ErrorUtils.containsErrorType(type2);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE.renderType(type2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$OnType;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "variablePresentation", "", "idea"})
    public static final class OnType
    extends ChangeVariableTypeFix
    implements HighPriorityAction {
        @Nullable
        public Void variablePresentation() {
            return null;
        }

        public OnType(@NotNull KtVariableDeclaration element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$ForOverridden;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "element", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "variablePresentation", "", "idea"})
    public static final class ForOverridden
    extends ChangeVariableTypeFix {
        @Override
        @Nullable
        public String variablePresentation() {
            String string = super.variablePresentation();
            if (string == null) {
                return null;
            }
            String presentation = string;
            return "base property " + presentation;
        }

        public ForOverridden(@NotNull KtVariableDeclaration element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$ComponentFunctionReturnTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ComponentFunctionReturnTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ComponentFunctionReturnTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtDestructuringDeclarationEntry entry = ChangeFunctionReturnTypeFix.Companion.getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
            BindingContext context = ResolutionUtils.analyze$default(entry, null, 1, null);
            ResolvedCall resolvedCall2 = (ResolvedCall)context.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)resolvedCall3.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"resolvedCall.candidateDescriptor");
            if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor) == null) {
                return null;
            }
            KotlinType kotlinType = ((FunctionDescriptor)resolvedCall3.getCandidateDescriptor()).getReturnType();
            if (kotlinType == null) {
                return null;
            }
            KotlinType expectedType = kotlinType;
            KtVariableDeclaration ktVariableDeclaration = entry;
            KotlinType kotlinType2 = expectedType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"expectedType");
            return new ChangeVariableTypeFix(ktVariableDeclaration, kotlinType2);
        }

        private ComponentFunctionReturnTypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new ComponentFunctionReturnTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$PropertyOrReturnTypeMismatchOnOverrideFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class PropertyOrReturnTypeMismatchOnOverrideFactory
    extends KotlinIntentionActionsFactory {
        public static final PropertyOrReturnTypeMismatchOnOverrideFactory INSTANCE;

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            LinkedList<ChangeVariableTypeFix> actions2 = new LinkedList<ChangeVariableTypeFix>();
            if (diagnostic.getPsiElement() instanceof KtProperty) {
                PsiElement psiElement;
                PsiElement psiElement2 = diagnostic.getPsiElement();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                KtProperty property2 = (KtProperty)psiElement2;
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(property2);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor == null) {
                    return actions2;
                }
                PropertyDescriptor descriptor2 = propertyDescriptor;
                KotlinType lowerBoundOfOverriddenPropertiesTypes = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(descriptor2);
                KotlinType kotlinType = descriptor2.getReturnType();
                if (kotlinType == null) {
                    String string = "Property type cannot be null if it mismatches something";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                KotlinType propertyType = kotlinType;
                LinkedList<PropertyDescriptor> overriddenMismatchingProperties = new LinkedList<PropertyDescriptor>();
                boolean canChangeOverriddenPropertyType = true;
                for (PropertyDescriptor propertyDescriptor2 : descriptor2.getOverriddenDescriptors()) {
                    KotlinType overriddenPropertyType = propertyDescriptor2.getReturnType();
                    if (overriddenPropertyType == null) continue;
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(propertyType, overriddenPropertyType)) {
                        overriddenMismatchingProperties.add(propertyDescriptor2);
                    } else if (propertyDescriptor2.isVar() && !KotlinTypeChecker.DEFAULT.equalTypes(overriddenPropertyType, propertyType)) {
                        canChangeOverriddenPropertyType = false;
                    }
                    if (!propertyDescriptor2.isVar() || lowerBoundOfOverriddenPropertiesTypes == null || KotlinTypeChecker.DEFAULT.equalTypes(lowerBoundOfOverriddenPropertiesTypes, overriddenPropertyType)) continue;
                    lowerBoundOfOverriddenPropertiesTypes = null;
                }
                if (lowerBoundOfOverriddenPropertiesTypes != null) {
                    actions2.add(new OnType(property2, lowerBoundOfOverriddenPropertiesTypes));
                }
                if (overriddenMismatchingProperties.size() == 1 && canChangeOverriddenPropertyType && (psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)CollectionsKt.single((List)overriddenMismatchingProperties))) instanceof KtProperty) {
                    KtVariableDeclaration ktVariableDeclaration = (KtVariableDeclaration)psiElement;
                    KotlinType kotlinType2 = propertyType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"propertyType");
                    actions2.add(new ForOverridden(ktVariableDeclaration, kotlinType2));
                }
            }
            return actions2;
        }

        private PropertyOrReturnTypeMismatchOnOverrideFactory() {
            INSTANCE = this;
        }

        static {
            new PropertyOrReturnTypeMismatchOnOverrideFactory();
        }
    }
}

