/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionLiteralReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000b\u001d\u001e\u001f !\"#$%&'B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J\r\u0010\u0010\u001a\u00070\r\u00a2\u0006\u0002\b\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "changeFunctionLiteralReturnTypeFix", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix;", "isUnitType", "", "typeContainsError", "typePresentation", "", "typeSourceCode", "functionPresentation", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "ChangingReturnTypeToNothingFactory", "ChangingReturnTypeToUnitFactory", "Companion", "CompareToTypeMismatchFactory", "ComponentFunctionReturnTypeMismatchFactory", "ForCalled", "ForEnclosing", "ForOverridden", "HasNextFunctionTypeMismatchFactory", "OnType", "ReturnTypeMismatchOnOverrideFactory", "idea"})
public abstract class ChangeFunctionReturnTypeFix
extends KotlinQuickFixAction<KtFunction> {
    private final ChangeFunctionLiteralReturnTypeFix changeFunctionLiteralReturnTypeFix;
    private final boolean typeContainsError;
    private final String typePresentation;
    private final String typeSourceCode;
    private final boolean isUnitType;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String functionPresentation() {
        String name2 = ((KtFunction)this.getElement()).getName();
        if (name2 != null) {
            ClassDescriptor container2;
            Object object;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor((KtDeclaration)this.getElement()).getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            String containerName2 = (object = (container2 = (ClassDescriptor)declarationDescriptor)) != null && (object = object.getName()) != null && (object = (Name)AddToStdlibKt.check(object, functionPresentation.containerName.1.INSTANCE)) != null ? ((Name)object).asString() : null;
            return "function " + (containerName2 != null ? "'" + containerName2 + "." + name2 + "'" : "'" + name2 + "'");
        }
        return null;
    }

    @NotNull
    public String getText() {
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            String string = this.changeFunctionLiteralReturnTypeFix.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"changeFunctionLiteralReturnTypeFix.text");
            return string;
        }
        String functionPresentation2 = this.functionPresentation();
        if (this.isUnitType && ((KtFunction)this.getElement()).hasBlockBody()) {
            return functionPresentation2 == null ? "Remove explicitly specified return type" : "Remove explicitly specified return type of " + functionPresentation2;
        }
        return functionPresentation2 == null ? "Change return type to '" + this.typePresentation + "'" : "Change return type of " + functionPresentation2 + " to '" + this.typePresentation + "'";
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("change.type.family", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return super.isAvailable(project, editor, file2) && !this.typeContainsError && !(this.getElement() instanceof KtConstructor);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            Editor editor2 = editor;
            if (editor2 == null) {
                Intrinsics.throwNpe();
            }
            this.changeFunctionLiteralReturnTypeFix.invoke(project, editor2, (PsiFile)file2);
        } else if (!this.isUnitType || !((KtFunction)this.getElement()).hasBlockBody()) {
            KtTypeReference newTypeRef = new KtPsiFactory(project).createType(this.typeSourceCode);
            KtTypeReference ktTypeReference = ((KtFunction)this.getElement()).setTypeReference(newTypeRef);
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            newTypeRef = ktTypeReference;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, newTypeRef, null, 2, null);
        } else {
            ((KtFunction)this.getElement()).setTypeReference(null);
        }
    }

    public ChangeFunctionReturnTypeFix(@NotNull KtFunction element2, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element2);
        this.typeContainsError = ErrorUtils.containsErrorType(type2);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE.renderType(type2);
        this.isUnitType = TypeUtilsKt.isUnit(type2);
        if (element2 instanceof KtFunctionLiteral) {
            KtLambdaExpression functionLiteralExpression;
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtLambdaExpression.class);
            if (ktLambdaExpression == null) {
                String string = "FunctionLiteral outside any FunctionLiteralExpression: " + PsiUtilsKt.getElementTextWithContext(element2);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtLambdaExpression ktLambdaExpression2 = functionLiteralExpression = ktLambdaExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktLambdaExpression2, (String)"functionLiteralExpression");
            this.changeFunctionLiteralReturnTypeFix = new ChangeFunctionLiteralReturnTypeFix(ktLambdaExpression2, type2);
        } else {
            this.changeFunctionLiteralReturnTypeFix = null;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$OnType;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class OnType
    extends ChangeFunctionReturnTypeFix
    implements HighPriorityAction {
        @Nullable
        public Void functionPresentation() {
            return null;
        }

        public OnType(@NotNull KtFunction element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$ForEnclosing;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class ForEnclosing
    extends ChangeFunctionReturnTypeFix
    implements HighPriorityAction {
        @Override
        @Nullable
        public String functionPresentation() {
            String string = super.functionPresentation();
            if (string == null) {
                return "enclosing function";
            }
            String presentation = string;
            return "enclosing " + presentation;
        }

        public ForEnclosing(@NotNull KtFunction element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$ForCalled;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix;", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class ForCalled
    extends ChangeFunctionReturnTypeFix {
        @Override
        @Nullable
        public String functionPresentation() {
            String string = super.functionPresentation();
            if (string == null) {
                return "called function";
            }
            String presentation = string;
            return "called " + presentation;
        }

        public ForCalled(@NotNull KtFunction element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$ForOverridden;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix;", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class ForOverridden
    extends ChangeFunctionReturnTypeFix {
        @Override
        @Nullable
        public String functionPresentation() {
            String string = super.functionPresentation();
            if (string == null) {
                return null;
            }
            String presentation = string;
            return "base " + presentation;
        }

        public ForOverridden(@NotNull KtFunction element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$ComponentFunctionReturnTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ComponentFunctionReturnTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ComponentFunctionReturnTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KotlinType expectedType;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtDestructuringDeclarationEntry entry = Companion.getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
            BindingContext context = ResolutionUtils.analyze(entry, BodyResolveMode.PARTIAL);
            ResolvedCall resolvedCall2 = (ResolvedCall)context.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)resolvedCall3.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"resolvedCall.candidateDescriptor");
            KtFunction ktFunction = (KtFunction)DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (ktFunction == null) {
                return null;
            }
            KtFunction componentFunction = ktFunction;
            ReadOnlySlice readOnlySlice = BindingContext.TYPE;
            KtTypeReference ktTypeReference = entry.getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            KotlinType kotlinType = (KotlinType)context.get(readOnlySlice, ktTypeReference);
            if (kotlinType == null) {
                return null;
            }
            KotlinType kotlinType2 = expectedType = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"expectedType");
            return new ForCalled(componentFunction, kotlinType2);
        }

        private ComponentFunctionReturnTypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new ComponentFunctionReturnTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$HasNextFunctionTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class HasNextFunctionTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final HasNextFunctionTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtExpression ktExpression = QuickFixUtil.getParentElementOfType(diagnostic, KtExpression.class);
            if (ktExpression == null) {
                String string = "HAS_NEXT_FUNCTION_TYPE_MISMATCH reported on element that is not within any expression";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtExpression expression2 = ktExpression;
            BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            ResolvedCall resolvedCall2 = (ResolvedCall)context.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            FunctionDescriptor hasNextDescriptor = (FunctionDescriptor)resolvedCall3.getCandidateDescriptor();
            DeclarationDescriptor declarationDescriptor = hasNextDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"hasNextDescriptor");
            KtFunction ktFunction = (KtFunction)DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (ktFunction == null) {
                return null;
            }
            KtFunction hasNextFunction = ktFunction;
            KotlinType kotlinType = DescriptorUtilsKt.getBuiltIns(hasNextDescriptor).getBooleanType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"hasNextDescriptor.builtIns.booleanType");
            return new ForCalled(hasNextFunction, kotlinType);
        }

        private HasNextFunctionTypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new HasNextFunctionTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$CompareToTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class CompareToTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final CompareToTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtBinaryExpression ktBinaryExpression = QuickFixUtil.getParentElementOfType(diagnostic, KtBinaryExpression.class);
            if (ktBinaryExpression == null) {
                String string = "COMPARE_TO_TYPE_MISMATCH reported on element that is not within any expression";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtBinaryExpression expression2 = ktBinaryExpression;
            BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            CallableDescriptor compareToDescriptor = resolvedCall3.getCandidateDescriptor();
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(compareToDescriptor);
            if (!(psiElement instanceof KtFunction)) {
                psiElement = null;
            }
            KtFunction ktFunction = (KtFunction)psiElement;
            if (ktFunction == null) {
                return null;
            }
            KtFunction compareTo = ktFunction;
            KotlinType kotlinType = DescriptorUtilsKt.getBuiltIns(compareToDescriptor).getIntType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"compareToDescriptor.builtIns.intType");
            return new ForCalled(compareTo, kotlinType);
        }

        private CompareToTypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new CompareToTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$ReturnTypeMismatchOnOverrideFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ReturnTypeMismatchOnOverrideFactory
    extends KotlinIntentionActionsFactory {
        public static final ReturnTypeMismatchOnOverrideFactory INSTANCE;

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtFunction ktFunction = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
            if (ktFunction == null) {
                return CollectionsKt.emptyList();
            }
            KtFunction function2 = ktFunction;
            LinkedList<ChangeFunctionReturnTypeFix> actions2 = new LinkedList<ChangeFunctionReturnTypeFix>();
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(function2);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor descriptor2 = (FunctionDescriptor)declarationDescriptor;
            KotlinType matchingReturnType = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(descriptor2);
            if (matchingReturnType != null) {
                KtFunction ktFunction2 = function2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction2, (String)"function");
                actions2.add(new OnType(ktFunction2, matchingReturnType));
            }
            KotlinType kotlinType = descriptor2.getReturnType();
            if (kotlinType == null) {
                return actions2;
            }
            KotlinType functionType = kotlinType;
            LinkedList<FunctionDescriptor> overriddenMismatchingFunctions = new LinkedList<FunctionDescriptor>();
            for (FunctionDescriptor functionDescriptor : descriptor2.getOverriddenDescriptors()) {
                KotlinType overriddenFunctionType;
                if (functionDescriptor.getReturnType() == null) {
                    continue;
                }
                if (KotlinTypeChecker.DEFAULT.isSubtypeOf(functionType, overriddenFunctionType)) continue;
                overriddenMismatchingFunctions.add(functionDescriptor);
            }
            if (overriddenMismatchingFunctions.size() == 1) {
                DeclarationDescriptor declarationDescriptor2 = (DeclarationDescriptor)overriddenMismatchingFunctions.get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"overriddenMismatchingFunctions[0]");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor2);
                if (psiElement instanceof KtFunction) {
                    KtFunction ktFunction3 = (KtFunction)psiElement;
                    KotlinType kotlinType2 = functionType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"functionType");
                    actions2.add(new ForOverridden(ktFunction3, kotlinType2));
                }
            }
            return actions2;
        }

        private ReturnTypeMismatchOnOverrideFactory() {
            INSTANCE = this;
        }

        static {
            new ReturnTypeMismatchOnOverrideFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$ChangingReturnTypeToUnitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ChangingReturnTypeToUnitFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ChangingReturnTypeToUnitFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtFunction function2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtFunction ktFunction = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
            if (ktFunction == null) {
                return null;
            }
            KtFunction ktFunction2 = function2 = ktFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction2, (String)"function");
            KotlinType kotlinType = PlatformKt.getPlatform(function2).getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"function.platform.builtIns.unitType");
            return new ForEnclosing(ktFunction2, kotlinType);
        }

        private ChangingReturnTypeToUnitFactory() {
            INSTANCE = this;
        }

        static {
            new ChangingReturnTypeToUnitFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$ChangingReturnTypeToNothingFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ChangingReturnTypeToNothingFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ChangingReturnTypeToNothingFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtFunction function2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtFunction ktFunction = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
            if (ktFunction == null) {
                return null;
            }
            KtFunction ktFunction2 = function2 = ktFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction2, (String)"function");
            KotlinType kotlinType = PlatformKt.getPlatform(function2).getBuiltIns().getNothingType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"function.platform.builtIns.nothingType");
            return new ForEnclosing(ktFunction2, kotlinType);
        }

        private ChangingReturnTypeToNothingFactory() {
            INSTANCE = this;
        }

        static {
            new ChangingReturnTypeToNothingFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$Companion;", "", "()V", "getDestructuringDeclarationEntryThatTypeMismatchComponentFunction", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion {
        @NotNull
        public final KtDestructuringDeclarationEntry getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Name componentName = (Name)((DiagnosticWithParameters3)Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.cast(diagnostic)).getA();
            String string = componentName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentName.asString()");
            int componentIndex = DataClassUtilsKt.getComponentIndex(string);
            KtDestructuringDeclaration ktDestructuringDeclaration = QuickFixUtil.getParentElementOfType(diagnostic, KtDestructuringDeclaration.class);
            if (ktDestructuringDeclaration == null) {
                String string2 = "COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH reported on expression that is not within any multi declaration";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            KtDestructuringDeclaration multiDeclaration = ktDestructuringDeclaration;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = multiDeclaration.getEntries().get(componentIndex - 1);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"multiDeclaration.entries[componentIndex - 1]");
            return ktDestructuringDeclarationEntry;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

