/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinJavaMavenConfigurator;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinJavascriptMavenConfigurator;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.maven.inspections.KotlinMavenPluginPhaseInspectionKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\f\r\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getStaticDescription", "", "AddExecutionLocalFix", "AddJavaExecutionsLocalFix", "ConfigurePluginExecutionLocalFix", "FixAddStdlibLocalFix", "FixExecutionPhaseLocalFix", "idea-maven"})
public final class KotlinMavenPluginPhaseInspection
extends DomElementsInspection<MavenDomProjectModel> {
    @NotNull
    public String getStaticDescription() {
        return "Reports kotlin-maven-plugin configuration issues";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        if (domFileElement == null || holder == null) {
            return;
        }
        v0 = domFileElement.getModule();
        if (v0 == null) {
            return;
        }
        module = v0;
        manager = MavenProjectsManager.getInstance((Project)module.getProject());
        v1 = manager.findProject(module);
        if (v1 == null) {
            return;
        }
        mavenProject = v1;
        v2 = domFileElement.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"domFileElement.file");
        pom = new PomFile(v2);
        hasJavaFiles = KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(module);
        var9_8 = mavenProject.getPlugins();
        var10_9 = $receiver$iv;
        var11_11 = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            if (!KotlinMavenPluginPhaseInspectionKt.access$isKotlinMavenPlugin(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            list$iv$iv = it.getExecutions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        executions = (List)destination$iv$iv;
        $receiver$iv$iv = executions;
        destination$iv$iv = new HashSet<E>();
        for (T element$iv : $receiver$iv) {
            it = (MavenPlugin.Execution)element$iv;
            v3 = it.getGoals();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it.goals");
            list$iv = v3;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        allGoalsSet = (Set)destination$iv;
        hasJvmExecution = allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getCompile()) != false || allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getTestCompile()) != false;
        hasJsExecution = allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getJs()) != false || allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getTestJs()) != false;
        pomKotlinPlugins = pom.findKotlinPlugins();
        for (MavenDomPlugin kotlinPlugin : pomKotlinPlugins) {
            if (allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getCompile()) ^ true && allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getJs()) ^ true) {
                if (hasJavaFiles) {
                    v4 = new AddExecutionLocalFix[1];
                    v5 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"domFileElement.file");
                    v6 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"module");
                    v7 = kotlinPlugin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"kotlinPlugin");
                    v4[0] = new AddExecutionLocalFix(v5, v6, v7, PomFile.KotlinGoals.INSTANCE.getCompile());
                    $i$f$flatMapTo = v4;
                    v8 = (AddExecutionLocalFix[])((Object[])elements$iv);
                } else {
                    v9 = new AddExecutionLocalFix[2];
                    v10 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"domFileElement.file");
                    v11 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"module");
                    v12 = kotlinPlugin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"kotlinPlugin");
                    v9[0] = new AddExecutionLocalFix(v10, v11, v12, PomFile.KotlinGoals.INSTANCE.getCompile());
                    v13 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"domFileElement.file");
                    v14 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"module");
                    v15 = kotlinPlugin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"kotlinPlugin");
                    v9[1] = new AddExecutionLocalFix(v13, v14, v15, PomFile.KotlinGoals.INSTANCE.getJs());
                    elements$iv = v9;
                    v8 = (AddExecutionLocalFix[])((Object[])elements$iv);
                }
                fixes = v8;
                v16 = fixes;
                holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, "Kotlin plugin has no compile executions", Arrays.copyOf(v16, v16.length));
                continue;
            }
            if (hasJavaFiles) {
                v17 = kotlinPlugin;
                Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"kotlinPlugin");
                fixes = (AddExecutionLocalFix[])KotlinMavenPluginPhaseInspectionKt.access$notAtPhase(pom.findExecutions(v17, new String[]{PomFile.KotlinGoals.INSTANCE.getCompile()}), PomFile.DefaultPhases.INSTANCE.getProcessSources());
                for (T element$iv : $receiver$iv) {
                    block29: {
                        badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
                        javacPlugin /* !! */  = mavenProject.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
                        var20_22 = pom.getDomModel().getBuild().getPlugins().getPlugins();
                        for (T element$iv : $receiver$iv) {
                            it = (MavenDomPlugin)element$iv;
                            if (!(Intrinsics.areEqual((Object)it.getGroupId().getStringValue(), (Object)"org.apache.maven.plugins") != false && Intrinsics.areEqual((Object)it.getArtifactId().getStringValue(), (Object)"maven-compiler-plugin") != false)) continue;
                            v18 = element$iv;
                            break block29;
                        }
                        v18 = null;
                    }
                    existingJavac /* !! */  = v18;
                    if (existingJavac /* !! */  != null) {
                        v19 = kotlinPlugin;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"kotlinPlugin");
                        if (pom.isPluginAfter(existingJavac /* !! */ , v19) && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-compile") && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-testCompile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-compile", "compile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-testCompile", "testCompile")) continue;
                    }
                    v20 = badExecution.getPhase().createStableCopy();
                    v21 = new LocalQuickFix[2];
                    v21[0] = new FixExecutionPhaseLocalFix(badExecution, PomFile.DefaultPhases.INSTANCE.getProcessSources());
                    v22 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"module");
                    v23 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"domFileElement.file");
                    v24 = kotlinPlugin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"kotlinPlugin");
                    v21[1] = new AddJavaExecutionsLocalFix(v22, v23, v24);
                    holder.createProblem(v20, HighlightSeverity.WARNING, "Kotlin plugin should run before javac so kotlin classes could be visible from Java", v21);
                }
                v25 = kotlinPlugin;
                Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"kotlinPlugin");
                $receiver$iv = pom.findExecutions(v25, new String[]{PomFile.KotlinGoals.INSTANCE.getJs(), PomFile.KotlinGoals.INSTANCE.getTestJs()});
                elements$iv = $receiver$iv.iterator();
                while (elements$iv.hasNext()) {
                    block30: {
                        element$iv /* !! */  = elements$iv.next();
                        badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
                        javacPlugin /* !! */  = badExecution.getGoals().getGoals();
                        $receiver$iv = holder;
                        for (T element$iv : $receiver$iv) {
                            it = (MavenDomGoal)element$iv;
                            if (!KotlinMavenPluginPhaseInspectionKt.access$isJsGoal((MavenDomGoal)it)) continue;
                            break block30;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    existingJavac /* !! */  = element$iv;
                    $receiver$iv.createProblem(((MavenDomGoal)existingJavac /* !! */ ).createStableCopy(), HighlightSeverity.WARNING, "JavaScript goal configured for module with Java files");
                }
            }
            stdlibDependencies = mavenProject.findDependencies(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinJavaMavenConfigurator.Companion.getSTD_LIB_ID());
            jsDependencies = mavenProject.findDependencies(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinJavascriptMavenConfigurator.Companion.getSTD_LIB_ID());
            if (hasJvmExecution && stdlibDependencies.isEmpty()) {
                v26 = kotlinPlugin.getArtifactId().createStableCopy();
                v27 = "Kotlin JVM compiler configured but no " + KotlinJavaMavenConfigurator.Companion.getSTD_LIB_ID() + " dependency";
                v28 = new LocalQuickFix[1];
                v29 = domFileElement.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v29, (String)"domFileElement.file");
                v28[0] = new FixAddStdlibLocalFix(v29, KotlinJavaMavenConfigurator.Companion.getSTD_LIB_ID(), kotlinPlugin.getVersion().getRawText());
                holder.createProblem(v26, HighlightSeverity.WARNING, v27, v28);
            }
            if (!hasJsExecution || !jsDependencies.isEmpty()) continue;
            v30 = kotlinPlugin.getArtifactId().createStableCopy();
            v31 = "Kotlin JavaScript compiler configured but no " + KotlinJavascriptMavenConfigurator.Companion.getSTD_LIB_ID() + " dependency";
            v32 = new LocalQuickFix[1];
            v33 = domFileElement.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v33, (String)"domFileElement.file");
            v32[0] = new FixAddStdlibLocalFix(v33, KotlinJavascriptMavenConfigurator.Companion.getSTD_LIB_ID(), kotlinPlugin.getVersion().getRawText());
            holder.createProblem(v30, HighlightSeverity.WARNING, v31, v32);
        }
        stdlibDependencies = PomFile.findDependencies$default(pom, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinJavaMavenConfigurator.Companion.getSTD_LIB_ID(), (String)null), null, 2, null);
        if (!hasJvmExecution) {
            list$iv = stdlibDependencies;
            if (list$iv.isEmpty() == false) {
                list$iv = stdlibDependencies;
                for (Object element$iv : $receiver$iv) {
                    dep = (MavenDomDependency)element$iv;
                    v34 = dep.getArtifactId().createStableCopy();
                    v35 = "You have " + dep.getArtifactId() + " configured but no corresponding plugin execution";
                    v36 = new LocalQuickFix[1];
                    v37 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v37, (String)"module");
                    v38 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v38, (String)"domFileElement.file");
                    v36[0] = new ConfigurePluginExecutionLocalFix(v37, v38, PomFile.KotlinGoals.INSTANCE.getCompile(), dep.getVersion().getRawText());
                    holder.createProblem(v34, HighlightSeverity.WARNING, v35, v36);
                }
            }
        }
        stdlibJsDependencies = PomFile.findDependencies$default(pom, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinJavascriptMavenConfigurator.Companion.getSTD_LIB_ID(), (String)null), null, 2, null);
        if (!hasJsExecution) {
            stdlibDependencies = stdlibJsDependencies;
            if (stdlibDependencies.isEmpty() == false) {
                stdlibDependencies = stdlibJsDependencies;
                for (T element$iv : $receiver$iv) {
                    dep = (MavenDomDependency)element$iv /* !! */ ;
                    v39 = dep.getArtifactId().createStableCopy();
                    v40 = "You have " + dep.getArtifactId() + " configured but no corresponding plugin execution";
                    v41 = new LocalQuickFix[1];
                    v42 = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v42, (String)"module");
                    v43 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v43, (String)"domFileElement.file");
                    v41[0] = new ConfigurePluginExecutionLocalFix(v42, v43, PomFile.KotlinGoals.INSTANCE.getJs(), dep.getVersion().getRawText());
                    holder.createProblem(v39, HighlightSeverity.WARNING, v40, v41);
                }
            }
        }
        $receiver$iv = pom.findKotlinExecutions();
        element$iv = $receiver$iv;
        element$iv /* !! */  = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            block32: {
                block31: {
                    it = (MavenDomPluginExecution)element$iv$iv;
                    var21_23 = it.getGoals().getGoals();
                    for (T element$iv : $receiver$iv) {
                        it = (MavenDomGoal)element$iv;
                        if (!(Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getCompile()) != false || Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getJs()) != false)) continue;
                        v44 = true;
                        break block31;
                    }
                    v44 = false;
                }
                if (!v44) ** GOTO lbl-1000
                $receiver$iv = it.getGoals().getGoals();
                for (T element$iv : $receiver$iv) {
                    it = (MavenDomGoal)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getTestCompile()) != false || Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getTestJs()) != false)) continue;
                    v45 = true;
                    break block32;
                }
                v45 = false;
            }
            if (v45) {
                v46 = true;
            } else lbl-1000:
            // 2 sources

            {
                v46 = false;
            }
            if (!v46) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (T element$iv : $receiver$iv) {
            badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
            holder.createProblem(badExecution.getGoals().createStableCopy(), HighlightSeverity.WEAK_WARNING, "It is not recommended to have both test and compile goals in the same execution");
        }
    }

    public KotlinMavenPluginPhaseInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "(Lcom/intellij/psi/xml/XmlFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/psi/xml/XmlFile;", "getGoal", "()Ljava/lang/String;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class AddExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final XmlFile file;
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final String goal;

        @NotNull
        public String getName() {
            return "Create " + this.goal + " execution";
        }

        @NotNull
        public String getFamilyName() {
            return "Create kotlin execution";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PomFile pom = new PomFile(this.file);
            pom.addKotlinExecution(this.module, this.kotlinPlugin, this.goal, PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
        }

        @NotNull
        public final XmlFile getFile() {
            return this.file;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        public AddExecutionLocalFix(@NotNull XmlFile file2, @NotNull Module module, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String goal) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
            Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
            this.file = file2;
            this.module = module;
            this.kotlinPlugin = kotlinPlugin;
            this.goal = goal;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixExecutionPhaseLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "execution", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "newPhase", "", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;Ljava/lang/String;)V", "getExecution", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "getNewPhase", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class FixExecutionPhaseLocalFix
    implements LocalQuickFix {
        @NotNull
        private final MavenDomPluginExecution execution;
        @NotNull
        private final String newPhase;

        @NotNull
        public String getName() {
            return "Change phase to " + this.newPhase;
        }

        @NotNull
        public String getFamilyName() {
            return "Change phase";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.execution.getPhase().setValue((Object)this.newPhase);
        }

        @NotNull
        public final MavenDomPluginExecution getExecution() {
            return this.execution;
        }

        @NotNull
        public final String getNewPhase() {
            return this.newPhase;
        }

        public FixExecutionPhaseLocalFix(@NotNull MavenDomPluginExecution execution, @NotNull String newPhase) {
            Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
            Intrinsics.checkParameterIsNotNull((Object)newPhase, (String)"newPhase");
            this.execution = execution;
            this.newPhase = newPhase;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddJavaExecutionsLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/xml/XmlFile;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;)V", "getFile", "()Lcom/intellij/psi/xml/XmlFile;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea-maven"})
    private static final class AddJavaExecutionsLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final XmlFile file;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;

        @NotNull
        public String getName() {
            return "Configure maven-compiler-plugin executions in the right order";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            new PomFile(this.file).addJavacExecutions(this.module, this.kotlinPlugin);
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final XmlFile getFile() {
            return this.file;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        public AddJavaExecutionsLocalFix(@NotNull Module module, @NotNull XmlFile file2, @NotNull MavenDomPlugin kotlinPlugin) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
            this.module = module;
            this.file = file2;
            this.kotlinPlugin = kotlinPlugin;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixAddStdlibLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pomFile", "Lcom/intellij/psi/xml/XmlFile;", "id", "", "version", "(Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getPomFile", "()Lcom/intellij/psi/xml/XmlFile;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class FixAddStdlibLocalFix
    implements LocalQuickFix {
        @NotNull
        private final XmlFile pomFile;
        @NotNull
        private final String id;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return "Add " + this.id + " dependency";
        }

        @NotNull
        public String getFamilyName() {
            return "Add dependency";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PomFile file2 = new PomFile(this.pomFile);
            PomFile.addDependency$default(file2, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), this.id, this.version), MavenArtifactScope.COMPILE, null, false, null, 28, null);
        }

        @NotNull
        public final XmlFile getPomFile() {
            return this.pomFile;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public FixAddStdlibLocalFix(@NotNull XmlFile pomFile, @NotNull String id, @Nullable String version) {
            Intrinsics.checkParameterIsNotNull((Object)pomFile, (String)"pomFile");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.pomFile = pomFile;
            this.id = id;
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$ConfigurePluginExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "goal", "", "version", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getVersion", "getXmlFile", "()Lcom/intellij/psi/xml/XmlFile;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class ConfigurePluginExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final XmlFile xmlFile;
        @NotNull
        private final String goal;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return "Create " + this.goal + " execution of kotlin-maven-compiler";
        }

        @NotNull
        public String getFamilyName() {
            return "Create kotlin execution";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PomFile pom = new PomFile(this.xmlFile);
            MavenDomPlugin plugin = pom.addKotlinPlugin(this.version);
            pom.addKotlinExecution(this.module, plugin, "compile", PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final XmlFile getXmlFile() {
            return this.xmlFile;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public ConfigurePluginExecutionLocalFix(@NotNull Module module, @NotNull XmlFile xmlFile, @NotNull String goal, @Nullable String version) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)xmlFile, (String)"xmlFile");
            Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
            this.module = module;
            this.xmlFile = xmlFile;
            this.goal = goal;
            this.version = version;
        }
    }
}

