/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0014\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildErrorString", "", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "Companion", "MyVisitor", "idea"})
public final class DifferentStdlibGradleVersionInspection
extends GradleBaseInspection {
    @NotNull
    private static final List<String> COMPILE_DEPENDENCY_STATEMENTS;
    public static final Companion Companion;

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @NotNull
    protected String buildErrorString(Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return "Plugin version (" + args[0] + ") is not the same as library version (" + args[1] + ")";
    }

    static {
        Companion = new Companion(null);
        COMPILE_DEPENDENCY_STATEMENTS = CollectionsKt.listOf((Object[])new String[]{"classpath", "compile"});
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$MyVisitor;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "(Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;)V", "visitClosure", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "idea"})
    private final class MyVisitor
    extends KotlinGradleInspectionVisitor {
        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $receiver$iv = (PsiElement)closure;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            if (Intrinsics.areEqual((Object)dependenciesCall.getInvokedExpression().getText(), (Object)"dependencies") ^ true) {
                return;
            }
            if (!(dependenciesCall.getParent() instanceof PsiFile)) {
                return;
            }
            GrCallExpression grCallExpression = Companion.findLibraryStatement(closure, "org.jetbrains.kotlin", "kotlin-stdlib");
            if (grCallExpression == null) {
                return;
            }
            GrCallExpression stdlibStatement = grCallExpression;
            PsiFile psiFile = closure.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"closure.containingFile");
            String string = Companion.getResolvedKotlinStdlibVersion(psiFile, "org.jetbrains.kotlin:kotlin-stdlib:");
            if (string == null) {
                return;
            }
            String stdlibVersion = string;
            PsiFile psiFile2 = closure.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"closure.containingFile");
            String gradlePluginVersion = KotlinGradleInspectionVisitorKt.getResolvedKotlinGradleVersion(psiFile2);
            if (Intrinsics.areEqual((Object)stdlibVersion, (Object)gradlePluginVersion) ^ true) {
                this.registerError((PsiElement)stdlibStatement, new Object[]{gradlePluginVersion, stdlibVersion});
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$Companion;", "", "()V", "COMPILE_DEPENDENCY_STATEMENTS", "", "", "getCOMPILE_DEPENDENCY_STATEMENTS", "()Ljava/util/List;", "findLibraryStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "libraryGroup", "libraryId", "getResolvedKotlinStdlibVersion", "file", "Lcom/intellij/psi/PsiFile;", "libraryNameMarker", "idea"})
    public static final class Companion {
        @NotNull
        public final List<String> getCOMPILE_DEPENDENCY_STATEMENTS() {
            return COMPILE_DEPENDENCY_STATEMENTS;
        }

        /*
         * WARNING - void declaration
         */
        private final GrCallExpression findLibraryStatement(GrClosableBlock closure, String libraryGroup, String libraryId) {
            void $receiver$iv;
            PsiElement psiElement = (PsiElement)closure;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrCallExpression.class);
            if (psiElementArray == null) {
                void elements$iv$iv;
                GrCallExpression[] grCallExpressionArray = new GrCallExpression[]{};
                psiElementArray = (PsiElement[])((Object[])elements$iv$iv);
            }
            GrCallExpression[] applicationStatements = (GrCallExpression[])psiElementArray;
            for (int i = 0; i < applicationStatements.length; ++i) {
                GrReferenceExpression startExpression;
                void $receiver$iv2;
                GrCallExpression statement = applicationStatements[i];
                PsiElement $i$f$getChildrenOfType = (PsiElement)statement;
                PsiElement[] psiElementArray2 = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv2, GrReferenceExpression.class);
                if (psiElementArray2 == null) {
                    void elements$iv$iv;
                    GrReferenceExpression[] grReferenceExpressionArray = new GrReferenceExpression[]{};
                    psiElementArray2 = (PsiElement[])((Object[])elements$iv$iv);
                }
                if ((GrReferenceExpression)ArraysKt.firstOrNull((Object[])psiElementArray2) == null) {
                    continue;
                }
                if (!this.getCOMPILE_DEPENDENCY_STATEMENTS().contains(startExpression.getText()) || !StringsKt.contains$default((CharSequence)statement.getText(), (CharSequence)libraryId, (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)statement.getText(), (CharSequence)libraryGroup, (boolean)false, (int)2, null)) continue;
                return statement;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final String getResolvedKotlinStdlibVersion(PsiFile file2, String libraryNameMarker) {
            void $receiver$iv$iv;
            void $receiver$iv;
            DataNode<ProjectData> dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(file2);
            if (dataNode == null) {
                return null;
            }
            DataNode<ProjectData> projectStructureNode = dataNode;
            Module module = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().getModuleForFile(file2.getVirtualFile());
            if (module == null) {
                return null;
            }
            Module module2 = module;
            Key key = ProjectKeys.MODULE;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.MODULE");
            Iterable iterable = KotlinGradleInspectionVisitorKt.findAll(projectStructureNode, key);
            Iterator iterator2 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                NodeWithData it = (NodeWithData)element$iv$iv;
                if (!Intrinsics.areEqual((Object)((ModuleData)it.getData()).getInternalName(), (Object)module2.getName())) continue;
                collection.add(element$iv$iv);
            }
            for (NodeWithData moduleData : (List)collection) {
                void destination$iv$iv2;
                void $receiver$iv$iv2;
                Object element$iv$iv;
                DataNode<?> dataNode2 = moduleData.getNode();
                Key key2 = GradleSourceSetData.KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"GradleSourceSetData.KEY");
                Iterable iterable2 = KotlinGradleInspectionVisitorKt.findAll(dataNode2, key2);
                Iterator iterator3 = iterable2;
                element$iv$iv = new ArrayList();
                for (Object element$iv$iv2 : $receiver$iv$iv2) {
                    NodeWithData it = (NodeWithData)element$iv$iv2;
                    if (!StringsKt.endsWith$default((String)((GradleSourceSetData)it.getData()).getInternalName(), (String)"main", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                for (NodeWithData sourceSetData : (List)destination$iv$iv2) {
                    DataNode<?> dataNode3 = sourceSetData.getNode();
                    Key key3 = ProjectKeys.LIBRARY_DEPENDENCY;
                    Intrinsics.checkExpressionValueIsNotNull((Object)key3, (String)"ProjectKeys.LIBRARY_DEPENDENCY");
                    for (NodeWithData nodeWithData : KotlinGradleInspectionVisitorKt.findAll(dataNode3, key3)) {
                        if (!StringsKt.startsWith$default((String)((LibraryDependencyData)nodeWithData.getData()).getExternalName(), (String)libraryNameMarker, (boolean)false, (int)2, null)) continue;
                        return StringsKt.substringAfter$default((String)((LibraryDependencyData)nodeWithData.getData()).getExternalName(), (String)libraryNameMarker, null, (int)2, null);
                    }
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

