/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroupKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspectionKt;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CustomSuppressableInspectionTool;", "()V", "suppressionKey", "", "getSuppressionKey", "()Ljava/lang/String;", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/SuppressIntentionAction;", "isSuppressedFor", "", "idea-analysis"})
public abstract class AbstractKotlinInspection
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    @Nullable
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element2) {
        if (element2 == null) {
            return (SuppressIntentionAction[])((Object[])new SuppressIntentionAction[0]);
        }
        HighlightDisplayLevel highlightDisplayLevel = this.getDefaultLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"defaultLevel");
        Collection $receiver$iv = KotlinSuppressableWarningProblemGroupKt.createSuppressWarningActions(element2, AbstractKotlinInspectionKt.access$toSeverity(highlightDisplayLevel), this.getSuppressionKey());
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        SuppressIntentionAction[] suppressIntentionActionArray = thisCollection$iv.toArray(new SuppressIntentionAction[thisCollection$iv.size()]);
        if (suppressIntentionActionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (SuppressIntentionAction[])((Object[])suppressIntentionActionArray);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element2) {
        Project project;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        SuppressManager suppressManager = SuppressManager.getInstance();
        if (suppressManager == null) {
            Intrinsics.throwNpe();
        }
        if (suppressManager.isSuppressedFor(element2, this.getID())) {
            return true;
        }
        Project project2 = project = element2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        KotlinSuppressCache kotlinSuppressCache2 = KotlinCacheService.Companion.getInstance(project2).getSuppressionCache();
        String string = this.getSuppressionKey();
        HighlightDisplayLevel highlightDisplayLevel = this.getDefaultLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"defaultLevel");
        return kotlinSuppressCache2.isSuppressed(element2, string, AbstractKotlinInspectionKt.access$toSeverity(highlightDisplayLevel));
    }

    @NotNull
    protected String getSuppressionKey() {
        return StringsKt.removePrefix((String)this.getShortName(), (CharSequence)"Kotlin");
    }
}

