/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenPropertyMarkerKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinDefinitionsSearcher;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"getOverriddenPropertyTooltip", "", "property", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isImplemented", "", "declaration", "navigateToPropertyOverriddenDeclarations", "", "e", "Ljava/awt/event/MouseEvent;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "idea"})
public final class OverridenPropertyMarkerKt {
    @Nullable
    public static final String getOverriddenPropertyTooltip(@NotNull KtNamedDeclaration property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        PsiElementProcessor.CollectElementsWithLimit overriddenInClassesProcessor = new PsiElementProcessor.CollectElementsWithLimit(5);
        AdapterProcessor consumer2 = new AdapterProcessor((Processor)new CommonProcessors.UniqueProcessor((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)overriddenInClassesProcessor)), (Function)getOverriddenPropertyTooltip.consumer.1.INSTANCE);
        for (PsiMethod method : KotlinLineMarkerProviderKt.getAccessorLightMethods(property2)) {
            if (overriddenInClassesProcessor.isOverflow()) continue;
            OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).forEach((Processor)consumer2);
        }
        boolean isImplemented = OverridenPropertyMarkerKt.isImplemented(property2);
        if (overriddenInClassesProcessor.isOverflow()) {
            return isImplemented ? KotlinBundle.message("property.is.implemented.too.many", new Object[0]) : KotlinBundle.message("property.is.overridden.too.many", new Object[0]);
        }
        Collection collectedClasses = overriddenInClassesProcessor.getCollection();
        if (collectedClasses.isEmpty()) {
            return null;
        }
        String start = isImplemented ? KotlinBundle.message("property.is.implemented.header", new Object[0]) : KotlinBundle.message("property.is.overridden.header", new Object[0]);
        String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
        Iterable iterable = collectedClasses;
        Comparator comparator = new PsiClassListCellRenderer().getComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"PsiClassListCellRenderer().comparator");
        return GutterIconTooltipHelper.composeText((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator), (String)start, (String)pattern);
    }

    /*
     * WARNING - void declaration
     */
    public static final void navigateToPropertyOverriddenDeclarations(@Nullable MouseEvent e, @NotNull KtProperty property2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Project project = property2.getProject();
        if (DumbService.isDumb((Project)project)) {
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService != null) {
                dumbService.showDumbModeNotification("Navigation to overriding classes is not possible during index update");
            }
            return;
        }
        LightClassUtil.PropertyAccessorsPsiMethods psiPropertyMethods = LightClassUtil.INSTANCE.getLightClassPropertyMethods(property2);
        CommonProcessors.CollectUniquesProcessor elementProcessor = new CommonProcessors.CollectUniquesProcessor();
        Runnable jetPsiMethodProcessor2 = new Runnable(psiPropertyMethods, project, elementProcessor){
            final /* synthetic */ LightClassUtil.PropertyAccessorsPsiMethods $psiPropertyMethods;
            final /* synthetic */ Project $project;
            final /* synthetic */ CommonProcessors.CollectUniquesProcessor $elementProcessor;

            public final void run() {
                SearchScope searchScope2 = (SearchScope)GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"GlobalSearchScope.allScope(project)");
                KotlinDefinitionsSearcher.Companion.processPropertyImplementationsMethods(this.$psiPropertyMethods, searchScope2, (Processor<PsiElement>)((Processor)this.$elementProcessor));
            }
            {
                this.$psiPropertyMethods = propertyAccessorsPsiMethods;
                this.$project = project;
                this.$elementProcessor = collectUniquesProcessor;
            }
        };
        MouseEvent mouseEvent = e;
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(jetPsiMethodProcessor2, "Searching for Overriding Methods", true, project, (JComponent)(mouseEvent != null ? mouseEvent.getComponent() : null))) {
            return;
        }
        DefaultPsiElementCellRenderer renderer2 = new DefaultPsiElementCellRenderer();
        Iterable iterable = elementProcessor.getResults();
        Comparator comparator = renderer2.getComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"renderer.comparator");
        Iterable iterable2 = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        void var9_8 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof NavigatablePsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List navigatingOverrides = (List)destination$iv$iv;
        $receiver$iv = navigatingOverrides;
        MouseEvent mouseEvent2 = e;
        Collection thisCollection$iv = $receiver$iv;
        NavigatablePsiElement[] navigatablePsiElementArray = thisCollection$iv.toArray(new NavigatablePsiElement[thisCollection$iv.size()]);
        if (navigatablePsiElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = navigatablePsiElementArray;
        PsiElementListNavigator.openTargets((MouseEvent)mouseEvent2, (NavigatablePsiElement[])((NavigatablePsiElement[])objectArray), (String)KotlinBundle.message("navigation.title.overriding.property", property2.getName()), (String)KotlinBundle.message("navigation.findUsages.title.overriding.property", property2.getName()), (ListCellRenderer)((ListCellRenderer)renderer2));
    }

    public static final boolean isImplemented(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (declaration.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            return true;
        }
        PsiElement parent2 = declaration.getParent();
        PsiElement psiElement = parent2 = parent2 instanceof KtClassBody ? parent2.getParent() : parent2;
        if (!(parent2 instanceof KtClass)) {
            return false;
        }
        return !(!((KtClass)parent2).isInterface() || declaration instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)((Object)declaration)).hasBody() || declaration instanceof KtDeclarationWithInitializer && ((KtDeclarationWithInitializer)((Object)declaration)).hasInitializer());
    }
}

