/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.sun.jdi.Location;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodFilter;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepOverInlinedLinesHint;", "Lcom/intellij/debugger/engine/RequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "methodFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "filter", "myFrameCount", "", "myPosition", "Lcom/intellij/debugger/SourcePosition;", "mySteppedOut", "", "getDepth", "getNextStepDepth", "context", "isTheSameFrame", "idea"})
public final class KotlinStepOverInlinedLinesHint
extends RequestHint {
    private final Logger LOG;
    private boolean mySteppedOut;
    private int myFrameCount;
    private SourcePosition myPosition;
    private final KotlinMethodFilter filter;

    public int getDepth() {
        return 2;
    }

    private final boolean isTheSameFrame(SuspendContextImpl context) {
        if (this.mySteppedOut) {
            return false;
        }
        ThreadReferenceProxyImpl contextThread = context.getThread();
        if (contextThread != null) {
            try {
                int currentDepth = contextThread.frameCount();
                if (currentDepth < this.myFrameCount) {
                    this.mySteppedOut = true;
                }
                return currentDepth == this.myFrameCount;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return false;
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            StackFrameProxyImpl frameProxy = context.getFrameProxy();
            if (frameProxy != null) {
                if (this.isTheSameFrame(context)) {
                    Location location2 = frameProxy.location();
                    Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"frameProxy.location()");
                    if (this.filter.locationMatches(context, location2)) {
                        return 0;
                    }
                    return 2;
                }
                if (this.mySteppedOut) {
                    return 0;
                }
                return 3;
            }
        }
        catch (VMDisconnectedException ignored) {
        }
        catch (EvaluateException e) {
            this.LOG.error((Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KotlinStepOverInlinedLinesHint(final @NotNull ThreadReferenceProxyImpl stepThread, final @NotNull SuspendContextImpl suspendContext, @NotNull KotlinMethodFilter methodFilter2) {
        Intrinsics.checkParameterIsNotNull((Object)stepThread, (String)"stepThread");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)methodFilter2, (String)"methodFilter");
        super(stepThread, suspendContext, (MethodFilter)methodFilter2);
        this.LOG = Logger.getInstance(KotlinStepOverInlinedLinesHint.class);
        int frameCount = 0;
        SourcePosition position2 = null;
        try {
            frameCount = stepThread.frameCount();
            position2 = (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

                @Nullable
                public final SourcePosition compute() {
                    return ContextUtil.getSourcePosition((StackFrameContext)new StackFrameContext(){

                        @Nullable
                        public StackFrameProxy getFrameProxy() {
                            try {
                                return (StackFrameProxy)stepThread.frame(0);
                            }
                            catch (EvaluateException e) {
                                LOG.debug((Throwable)e);
                                return null;
                            }
                        }

                        @NotNull
                        public DebugProcess getDebugProcess() {
                            DebugProcess debugProcess = (DebugProcess)suspendContext.getDebugProcess();
                            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcess, (String)"suspendContext.debugProcess");
                            return debugProcess;
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.LOG.info((Throwable)e);
        }
        finally {
            this.myFrameCount = frameCount;
            this.myPosition = position2;
        }
        this.filter = methodFilter2;
    }
}

