/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.SMAPKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001bH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010-\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190\u00072\u0006\u0010/\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u00100\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u000eJ\f\u00101\u001a\u000202*\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerEx;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "scopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "classPrepareRequestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequests", "requestor", "position", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "expression", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getLambdaOrFunIfInside", "Lorg/jetbrains/kotlin/psi/KtFunction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "lineNumber", "", "getParameterIfInConstructor", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPsiFileByLocation", "Lcom/intellij/psi/PsiFile;", "getSourcePosition", "locationsOfLine", "type", "originalClassNameForPosition", "containsKotlinStrata", "", "idea"})
public final class KotlinPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private final List<GlobalSearchScope> scopes;
    private final DebugProcess myDebugProcess;

    @Nullable
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return ThreeState.UNSURE;
    }

    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        if (this.containsKotlinStrata(location2.declaringType())) {
            return (XStackFrame)new KotlinStackFrame(frame);
        }
        return null;
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        int e2;
        if (location2 == null) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        PsiFile psiFile = this.getPsiFileByLocation(location2);
        if (psiFile == null) {
            boolean isKotlinStrataAvailable = this.containsKotlinStrata(location2.declaringType());
            if (isKotlinStrataAvailable) {
                try {
                    Project project;
                    String javaSourceFileName = location2.sourceName("Java");
                    JvmClassName javaClassName = JvmClassName.byInternalName(this.defaultInternalName(location2));
                    Project project2 = project = this.myDebugProcess.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    JvmClassName jvmClassName = javaClassName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"javaClassName");
                    String string = javaSourceFileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaSourceFileName");
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.scopes, jvmClassName, string);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException e2) {
                    // empty catch block
                }
            }
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        try {
            e2 = location2.lineNumber() - 1;
        }
        catch (InternalError e3) {
            e2 = -1;
        }
        int lineNumber = e2;
        if (lineNumber < 0) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunIfInside(location2, (KtFile)psiFile2, lineNumber);
        if (lambdaOrFunIfInside != null) {
            KtExpression ktExpression = lambdaOrFunIfInside.getBodyExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            return SourcePosition.createFromElement((PsiElement)((PsiElement)ktExpression));
        }
        KtParameter property2 = this.getParameterIfInConstructor(location2, (KtFile)psiFile, lineNumber);
        if (property2 != null) {
            return SourcePosition.createFromElement((PsiElement)property2);
        }
        if (lineNumber > KotlinRefactoringUtilKt.getLineCount((PsiElement)psiFile) && NoStrataPositionManagerHelperKt.isDexDebug(this.myDebugProcess)) {
            int n = location2.lineNumber();
            FqName fqName2 = new FqName(location2.declaringType().name());
            String string = location2.sourceName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"location.sourceName()");
            Project project = this.myDebugProcess.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myDebugProcess.project");
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myDebugProcess.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(myDebugProcess.project)");
            Pair<KtFile, Integer> inlinePosition = NoStrataPositionManagerHelperKt.getOriginalPositionOfInlinedLine(n, fqName2, string, project, globalSearchScope);
            if (inlinePosition != null) {
                return SourcePosition.createFromLine((PsiFile)((PsiFile)inlinePosition.getFirst()), (int)((Number)inlinePosition.getSecond()).intValue());
            }
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    /*
     * Unable to fully structure code
     */
    private final KtParameter getParameterIfInConstructor(Location location, KtFile file, int lineNumber) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        v0 = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)file, lineNumber);
                        if (v0 == null) {
                            return null;
                        }
                        lineStartOffset = v0;
                        elementAt = file.findElementAt(lineStartOffset);
                        contextElement = KotlinCodeFragmentFactory.Companion.getContextElement(elementAt);
                        methodName = location.method().name();
                        if (!(contextElement instanceof KtClass) || !JvmAbi.isGetterName(methodName)) break block9;
                        v1 = ((KtClass)contextElement).getPrimaryConstructor();
                        if (v1 == null || (v1 = v1.getValueParameters()) == null) break block10;
                        var9_8 = (Iterable)v1;
                        for (T element$iv : $receiver$iv) {
                            it = (KtParameter)element$iv;
                            if (!it.hasValOrVar() || it.getName() == null) ** GOTO lbl-1000
                            v2 = it.getName();
                            if (v2 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (Intrinsics.areEqual((Object)JvmAbi.getterName(v2), (Object)methodName)) {
                                v3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = false;
                            }
                            if (!v3) continue;
                            v4 = element$iv;
                            break block8;
                        }
                        v4 = null;
                    }
                    if ((v1 = (KtParameter)v4) != null) break block11;
                }
                return null;
            }
            parameterForGetter = v1;
            return parameterForGetter;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunction getLambdaOrFunIfInside(Location location2, KtFile file2, int lineNumber) {
        PsiElement elementAt;
        String string = location2.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        Integer start = CodeInsightUtils.getStartLineOffset((PsiFile)file2, lineNumber);
        Integer end = CodeInsightUtils.getEndLineOffset((PsiFile)file2, lineNumber);
        if (start == null || end == null) {
            return null;
        }
        List<KtFunction> literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file2, lineNumber);
        if (literalsOrFunctions.isEmpty()) {
            return null;
        }
        PsiElement psiElement = file2.findElementAt(start);
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = elementAt = psiElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elementAt");
        KotlinTypeMapper typeMapper = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper(psiElement2);
        String currentLocationClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(currentLocationFqName)).getInternalName();
        for (KtFunction literal : literalsOrFunctions) {
            boolean bl;
            block8: {
                void $receiver$iv;
                if (InlineUtil.isInlinedArgument(literal, typeMapper.getBindingContext(), true)) {
                    DebugProcess debugProcess = this.myDebugProcess;
                    if (debugProcess == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                    }
                    if (!DebuggerUtilKt.isInsideInlineArgument(literal, location2, (DebugProcessImpl)debugProcess)) continue;
                    return literal;
                }
                List<String> internalClassNames = new DebuggerClassNameProvider(this.myDebugProcess, this.scopes).classNamesForPosition(literal.getFirstChild(), true);
                Iterable iterable = internalClassNames;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (!bl) continue;
            return literal;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        Project project;
        String string;
        String sourceName;
        try {
            String string2 = location2.sourceName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"location.sourceName()");
            sourceName = string2;
        }
        catch (AbsentInformationException e) {
            return null;
        }
        catch (InternalError e) {
            return null;
        }
        try {
            string = this.containsKotlinStrata(location2.declaringType()) ? StringsKt.replace$default((String)location2.sourcePath(), (char)'\\', (char)'/', (boolean)false, (int)4, null) : this.defaultInternalName(location2);
        }
        catch (AbsentInformationException e) {
            string = this.defaultInternalName(location2);
        }
        String referenceInternalName = string;
        JvmClassName className = JvmClassName.byInternalName(referenceInternalName);
        Project project2 = project = this.myDebugProcess.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        JvmClassName jvmClassName = className;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.scopes, jvmClassName, sourceName);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName = location2.declaringType().name();
        return StringsKt.replace$default((String)referenceFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition2.getFile();
        if (psiFile instanceof KtFile) {
            ArrayList result2 = new ArrayList();
            PsiElement psiElement = (PsiElement)psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"psiFile");
            if (!ProjectRootsUtil.isInProjectOrLibSource(psiElement)) {
                return result2;
            }
            List<String> names = new DebuggerClassNameProvider(this.myDebugProcess, this.scopes).classNamesForPosition(sourcePosition2, true);
            for (String name2 : names) {
                result2.addAll(this.myDebugProcess.getVirtualMachineProxy().classesByName(name2));
            }
            return result2;
        }
        if (psiFile instanceof ClsFileImpl) {
            void $receiver$iv;
            PsiFile names = psiFile;
            PsiFile decompiledPsiFile = (PsiFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiFile>((Object)$receiver$iv){
                final /* synthetic */ Object receiver$0;

                public final PsiFile invoke() {
                    ClsFileImpl it = (ClsFileImpl)this.receiver$0;
                    return it.getDecompiledPsiFile();
                }
                {
                    this.receiver$0 = object;
                    super(0);
                }
            });
            if (decompiledPsiFile instanceof KtClsFile && sourcePosition2.getLine() == -1) {
                String className = FileClasses.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)decompiledPsiFile).getFileClassFqName());
                List list2 = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"myDebugProcess.virtualMa\u2026.classesByName(className)");
                return list2;
            }
        }
        Throwable throwable = NoDataException.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
        throw throwable;
    }

    @Nullable
    public final String originalClassNameForPosition(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        return (String)CollectionsKt.firstOrNull(new DebuggerClassNameProvider(this.myDebugProcess, this.scopes).classNamesForPosition(sourcePosition2, false));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        if (!(position2.getFile() instanceof KtFile)) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        try {
            List locations;
            List list2;
            if (NoStrataPositionManagerHelperKt.isDexDebug(this.myDebugProcess)) {
                GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                List<Location> inlineLocations = NoStrataPositionManagerHelperKt.getLocationsOfInlinedLine(type2, position2, globalSearchScope);
                if (!inlineLocations.isEmpty()) {
                    return inlineLocations;
                }
            }
            int line = position2.getLine() + 1;
            if (this.myDebugProcess.getVirtualMachineProxy().versionHigher("1.4")) {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = type2.locationsOfLine(SMAPKt.getKOTLIN_STRATA_NAME(), null, line);
                void var6_7 = $receiver$iv;
                Collection collection = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Location it = (Location)element$iv$iv;
                    if (!Intrinsics.areEqual((Object)it.sourceName(SMAPKt.getKOTLIN_STRATA_NAME()), (Object)position2.getFile().getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = locations = type2.locationsOfLine(line);
            }
            if (locations == null || locations.isEmpty()) {
                Throwable throwable = NoDataException.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
                throw throwable;
            }
            return locations;
        }
        catch (AbsentInformationException e) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun")
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position2) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        if (!(position2.getFile() instanceof KtFile)) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        Iterable $receiver$iv = new DebuggerClassNameProvider(this.myDebugProcess, this.scopes).classNamesForPosition(position2, true);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        void var6_6 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassPrepareRequest classPrepareRequest;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            String className = (String)element$iv$iv;
            if (this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, StringsKt.replace$default((String)className, (char)'/', (char)'.', (boolean)false, (int)4, null)) == null) continue;
            ClassPrepareRequest it$iv$iv = classPrepareRequest;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean containsKotlinStrata(@NotNull ReferenceType $receiver) {
        return $receiver.availableStrata().contains(SMAPKt.getKOTLIN_STRATA_NAME());
    }

    public KotlinPositionManager(@NotNull DebugProcess myDebugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
        this.scopes = CollectionsKt.listOf((Object[])new GlobalSearchScope[]{this.myDebugProcess.getSearchScope(), KotlinSourceFilterScope.librarySources(GlobalSearchScope.allScope((Project)this.myDebugProcess.getProject()), this.myDebugProcess.getProject())});
    }
}

