/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.NoResolveFileClassesProvider;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u000203H\u0002J \u00104\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u00105\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u00106\u001a\u0004\u0018\u00010\u000b2\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0002J0\u00108\u001a\u0002092\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u0002032\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010<\u001a\u00020.H\u0002J\u0016\u0010=\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020&H\u0002J\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010C\u001a\u00020\u0013*\u00020\u0013H\u0002R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DebuggerClassNameProvider;", "", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "scopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/debugger/engine/DebugProcess;Ljava/util/List;)V", "TYPES_TO_CALCULATE_CLASSNAME", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtElement;", "[Ljava/lang/Class;", "getMyDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcess;", "getScopes", "()Ljava/util/List;", "classNamesForCrossInlineParameters", "", "", "usedParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "classNamesForPosition", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "withInlines", "", "element", "Lcom/intellij/psi/PsiElement;", "findCrossInlineArguments", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "parameterDescriptor", "findInlinedCalls", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findLambdas", "getArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "it", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getClassNameForClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "getClassNameForFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getCrossInlineArgumentClassName", "inlineFunctionName", "getElementToCalculateClassName", "notPositionedElement", "getInternalClassNameForElement", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "isInLibrary", "getJvmInternalNameForImpl", "ktClass", "getJvmInternalNameForPropertyOwner", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getScopeForInlineFunctionUsages", "inlineFunction", "containsCrossInlineParameterUsages", "substringIndex", "idea"})
public final class DebuggerClassNameProvider {
    private final Class<? extends KtElement>[] TYPES_TO_CALCULATE_CLASSNAME;
    @NotNull
    private final DebugProcess myDebugProcess;
    @NotNull
    private final List<GlobalSearchScope> scopes;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> classNamesForPosition(@NotNull SourcePosition sourcePosition2, boolean withInlines) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        SourcePosition sourcePosition3 = sourcePosition2;
        PsiElement psiElement = (PsiElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiElement>((Object)$receiver$iv){
            final /* synthetic */ Object receiver$0;

            public final PsiElement invoke() {
                SourcePosition it = (SourcePosition)this.receiver$0;
                return it.getElementAt();
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element2 = psiElement;
        List<String> names = this.classNamesForPosition(element2, withInlines);
        Collection<String> lambdas = this.findLambdas(sourcePosition2);
        if (lambdas.isEmpty()) {
            return names;
        }
        return CollectionsKt.plus((Collection)names, (Iterable)lambdas);
    }

    @NotNull
    public final List<String> classNamesForPosition(@Nullable PsiElement element2, boolean withInlines) {
        if (DumbService.getInstance((Project)this.myDebugProcess.getProject()).isDumb()) {
            return CollectionsKt.emptyList();
        }
        KtElement ktElement = this.getElementToCalculateClassName(element2);
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement baseElement = ktElement;
        return KotlinDebuggerCaches.Companion.getOrComputeClassNames((PsiElement)baseElement, (Function1)new Function1<KtElement, KotlinDebuggerCaches.ComputedClassNames>(this, withInlines){
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ boolean $withInlines;

            @NotNull
            public final KotlinDebuggerCaches.ComputedClassNames invoke(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                KtElement $receiver$iv = element2;
                KtFile file2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>((Object)$receiver$iv){
                    final /* synthetic */ Object receiver$0;

                    public final KtFile invoke() {
                        KtElement it = (KtElement)this.receiver$0;
                        PsiFile psiFile = it.getContainingFile();
                        if (psiFile == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                        }
                        return (KtFile)psiFile;
                    }
                    {
                        this.receiver$0 = object;
                        super(0);
                    }
                });
                boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject()) != null;
                KotlinTypeMapper typeMapper = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper((PsiElement)element2);
                return DebuggerClassNameProvider.access$getInternalClassNameForElement(this.this$0, element2, typeMapper, file2, isInLibrary, this.$withInlines);
            }
            {
                this.this$0 = debuggerClassNameProvider;
                this.$withInlines = bl;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> findLambdas(SourcePosition sourcePosition2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object $receiver$iv = sourcePosition2;
        List lambdas = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends KtFunction>>($receiver$iv){
            final /* synthetic */ Object receiver$0;

            public final List<? extends KtFunction> invoke() {
                SourcePosition p1 = (SourcePosition)this.receiver$0;
                return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(p1);
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
        $receiver$iv = lambdas;
        Object $i$f$readAction = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            Iterable list$iv$iv = this.classNamesForPosition(it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KotlinDebuggerCaches.ComputedClassNames getInternalClassNameForElement(KtElement element2, KotlinTypeMapper typeMapper, KtFile file2, boolean isInLibrary, boolean withInlines) {
        String string;
        String string2;
        Collection crossInlineParameterUsages;
        void $receiver$iv;
        KtElement $receiver$iv2;
        KtElement ktElement = element2;
        KtElement parent2 = (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>((Object)$receiver$iv2, this){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;

            public final KtElement invoke() {
                KtElement it = (KtElement)this.receiver$0;
                return DebuggerClassNameProvider.access$getElementToCalculateClassName(this.this$0, it.getParent());
            }
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                super(0);
            }
        });
        $receiver$iv2 = element2;
        if ($receiver$iv2 instanceof KtClassOrObject) {
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForClass((KtClassOrObject)element2, typeMapper));
        }
        if ($receiver$iv2 instanceof KtFunction) {
            KtElement ktElement2 = element2;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<ValueParameterDescriptor>((Object)$receiver$iv, typeMapper){
                final /* synthetic */ Object receiver$0;
                final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;

                public final ValueParameterDescriptor invoke() {
                    KtFunction it = (KtFunction)this.receiver$0;
                    return InlineUtil.getInlineArgumentDescriptor(it, this.$typeMapper$inlined.getBindingContext());
                }
                {
                    this.receiver$0 = object;
                    this.$typeMapper$inlined = kotlinTypeMapper;
                    super(0);
                }
            });
            if (valueParameterDescriptor != null) {
                List<String> classNamesForParent = this.classNamesForPosition((PsiElement)parent2, withInlines);
                if (!valueParameterDescriptor.isCrossinline()) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(classNamesForParent);
                Collection collection = classNamesForParent;
                KtFunction ktFunction = (KtFunction)element2;
                BindingContext bindingContext2 = typeMapper.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.bindingContext");
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.plus((Collection)collection, (Iterable)this.findCrossInlineArguments(ktFunction, valueParameterDescriptor, bindingContext2)));
            }
        }
        KtElement ktElement3 = element2;
        Collection collection = crossInlineParameterUsages = (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<? extends ValueParameterDescriptor>>((Object)ktElement3, this, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;

            public final Collection<? extends ValueParameterDescriptor> invoke() {
                KtElement it = (KtElement)this.receiver$0;
                BindingContext bindingContext2 = this.$typeMapper$inlined.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.bindingContext");
                return DebuggerClassNameProvider.access$containsCrossInlineParameterUsages(this.this$0, it, bindingContext2);
            }
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                this.$typeMapper$inlined = kotlinTypeMapper;
                super(0);
            }
        });
        if (!collection.isEmpty()) {
            BindingContext bindingContext3 = typeMapper.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"typeMapper.bindingContext");
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.toList((Iterable)this.classNamesForCrossInlineParameters(crossInlineParameterUsages, bindingContext3)));
        }
        if (element2 instanceof KtFunctionLiteral) {
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element2);
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(type2.getInternalName());
        }
        if (element2 instanceof KtAnonymousInitializer) {
            if (!(parent2 instanceof KtObjectDeclaration) || !((KtObjectDeclaration)parent2).isCompanion()) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition((PsiElement)parent2, withInlines));
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition(((KtObjectDeclaration)parent2).getParent(), withInlines));
        }
        if (element2 instanceof KtPropertyAccessor) {
            KtElement ktElement4 = element2;
            if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>((Object)ktElement4){
                final /* synthetic */ Object receiver$0;

                public final Boolean invoke() {
                    KtPropertyAccessor it = (KtPropertyAccessor)this.receiver$0;
                    return it.getProperty().isTopLevel();
                }
                {
                    this.receiver$0 = object;
                    super(0);
                }
            })).booleanValue() || !isInLibrary) {
                KtElement $i$f$readAction = element2;
                KtClassOrObject ktClassOrObject = (KtClassOrObject)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtClassOrObject>((Object)$receiver$iv){
                    final /* synthetic */ Object receiver$0;

                    public final KtClassOrObject invoke() {
                        KtPropertyAccessor it = (KtPropertyAccessor)this.receiver$0;
                        return (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)it, KtClassOrObject.class);
                    }
                    {
                        this.receiver$0 = object;
                        super(0);
                    }
                });
                if (ktClassOrObject == null) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForFile(file2));
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForClass(ktClassOrObject, typeMapper));
            }
        }
        if (element2 instanceof KtProperty) {
            KtElement ktElement5 = element2;
            if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>((Object)ktElement5){
                final /* synthetic */ Object receiver$0;

                public final Boolean invoke() {
                    KtProperty it = (KtProperty)this.receiver$0;
                    return it.isTopLevel();
                }
                {
                    this.receiver$0 = object;
                    super(0);
                }
            })).booleanValue() || !isInLibrary) {
                DeclarationDescriptor declarationDescriptor = typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
                if (declarationDescriptor instanceof PropertyDescriptor) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getJvmInternalNameForPropertyOwner(typeMapper, (PropertyDescriptor)declarationDescriptor));
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition((PsiElement)parent2, withInlines));
            }
        }
        if (!(element2 instanceof KtNamedFunction)) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForFile(file2));
        if (parent2 instanceof KtClassOrObject) {
            string2 = this.getClassNameForClass((KtClassOrObject)parent2, typeMapper);
        } else if (parent2 != null) {
            Type asmType = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element2);
            string2 = asmType.getInternalName();
        } else {
            string2 = string = this.getClassNameForFile(file2);
        }
        if (!withInlines) {
            return new KotlinDebuggerCaches.ComputedClassNames.NonCachedClassNames(string);
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)element2;
        BindingContext bindingContext4 = typeMapper.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext4, (String)"typeMapper.bindingContext");
        List<String> inlinedCalls = this.findInlinedCalls(ktNamedFunction, bindingContext4);
        if (string != null) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)string), (Iterable)inlinedCalls));
        return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(inlinedCalls);
    }

    private final String getClassNameForClass(KtClassOrObject klass2, KotlinTypeMapper typeMapper) {
        KtClassOrObject $receiver$iv = klass2;
        return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv, this, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;

            public final String invoke() {
                KtClassOrObject it = (KtClassOrObject)this.receiver$0;
                return DebuggerClassNameProvider.access$getJvmInternalNameForImpl(this.this$0, this.$typeMapper$inlined, it);
            }
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                this.$typeMapper$inlined = kotlinTypeMapper;
                super(0);
            }
        });
    }

    private final String getClassNameForFile(KtFile file2) {
        KtFile $receiver$iv = file2;
        return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv){
            final /* synthetic */ Object receiver$0;

            public final String invoke() {
                KtFile it = (KtFile)this.receiver$0;
                return FileClasses.getFileClassInternalName(NoResolveFileClassesProvider.INSTANCE, it);
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
    }

    private final KtElement getElementToCalculateClassName(PsiElement notPositionedElement) {
        PsiElement psiElement = notPositionedElement;
        Class<Object> clazz = psiElement != null ? psiElement.getClass() : null;
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        if (ArraysKt.contains((Object[])this.TYPES_TO_CALCULATE_CLASSNAME, clazz)) {
            PsiElement psiElement2 = notPositionedElement;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            return (KtElement)psiElement2;
        }
        DebuggerClassNameProvider $receiver$iv = this;
        return (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>((Object)$receiver$iv, this, notPositionedElement){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ PsiElement $notPositionedElement$inlined;

            public final KtElement invoke() {
                DebuggerClassNameProvider it = (DebuggerClassNameProvider)this.receiver$0;
                Class[] classArray = DebuggerClassNameProvider.access$getTYPES_TO_CALCULATE_CLASSNAME$p(this.this$0);
                return (KtElement)PsiTreeUtil.getParentOfType((PsiElement)this.$notPositionedElement$inlined, (Class[])Arrays.copyOf(classArray, classArray.length));
            }
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                this.$notPositionedElement$inlined = psiElement;
                super(0);
            }
        });
    }

    @NotNull
    public final String getJvmInternalNameForPropertyOwner(@NotNull KotlinTypeMapper typeMapper, @NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PropertyDescriptor $receiver$iv = descriptor2;
        String string = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;

            public final String invoke() {
                DeclarationDescriptor declarationDescriptor;
                PropertyDescriptor it = (PropertyDescriptor)this.receiver$0;
                if (JvmAbi.isPropertyWithBackingFieldInOuterClass(it)) {
                    DeclarationDescriptor declarationDescriptor2 = it.getContainingDeclaration();
                    declarationDescriptor = declarationDescriptor2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"it.containingDeclaration");
                } else {
                    declarationDescriptor = it;
                }
                String string = this.$typeMapper$inlined.mapOwner(declarationDescriptor).getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typeMapper.mapOwner(\n   \u2026           ).internalName");
                return string;
            }
            {
                this.receiver$0 = object;
                this.$typeMapper$inlined = kotlinTypeMapper;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.readAction {\n\u2026 ).internalName\n        }");
        return string;
    }

    private final String getJvmInternalNameForImpl(KotlinTypeMapper typeMapper, KtClassOrObject ktClass) {
        ClassDescriptor classDescriptor = (ClassDescriptor)typeMapper.getBindingContext().get(BindingContext.CLASS, ktClass);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (ktClass instanceof KtClass && ((KtClass)ktClass).isInterface()) {
            return typeMapper.mapDefaultImpls(classDescriptor2).getInternalName();
        }
        return typeMapper.mapClass(classDescriptor2).getInternalName();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findInlinedCalls(KtNamedFunction function2, BindingContext context) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        void isSuccess;
        void $receiver$iv2;
        if (!InlineUtil.isInline(context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2))) {
            return CollectionsKt.emptyList();
        }
        HashSet searchResult = SetsKt.hashSetOf((Object[])new KtElement[0]);
        KtNamedFunction ktNamedFunction = function2;
        String functionName2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv2){
            final /* synthetic */ Object receiver$0;

            public final String invoke() {
                KtNamedFunction it = (KtNamedFunction)this.receiver$0;
                return it.getName();
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
        Runnable task2 = new Runnable(this, function2, searchResult){
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ KtNamedFunction $function;
            final /* synthetic */ HashSet $searchResult;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)this.$function, (SearchScope)((SearchScope)DebuggerClassNameProvider.access$getScopeForInlineFunctionUsages(this.this$0, this.$function)));
                for (T element$iv : $receiver$iv) {
                    KtElement usage;
                    KtElement ktElement;
                    void $receiver$iv2;
                    PsiReference it;
                    PsiReference psiReference = it = (PsiReference)element$iv;
                    if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>((Object)$receiver$iv2){
                        final /* synthetic */ Object receiver$0;

                        public final Boolean invoke() {
                            PsiReference it = (PsiReference)this.receiver$0;
                            return UtilsKt.isImportUsage(it);
                        }
                        {
                            this.receiver$0 = object;
                            super(0);
                        }
                    })).booleanValue()) continue;
                    PsiElement psiElement = it.getElement();
                    if (!(psiElement instanceof KtElement)) {
                        psiElement = null;
                    }
                    if ((KtElement)psiElement != null) {
                        KtElement ktElement2;
                        KtElement it2 = ktElement2;
                        ktElement = DebuggerClassNameProvider.access$getElementToCalculateClassName(this.this$0, (PsiElement)it2);
                    } else {
                        ktElement = null;
                    }
                    if ((usage = ktElement) == null) continue;
                    this.$searchResult.add(usage);
                }
            }
            {
                this.this$0 = debuggerClassNameProvider;
                this.$function = ktNamedFunction;
                this.$searchResult = hashSet;
            }
        };
        Ref.BooleanRef $i$f$readAction = new Ref.BooleanRef();
        $i$f$readAction.element = true;
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        if (!(applicationEx.isUnitTestMode() || applicationEx.holdsReadLock() && !applicationEx.isDispatchThread())) {
            applicationEx.invokeAndWait(new Runnable(this, (Ref.BooleanRef)isSuccess, task2, functionName2){
                final /* synthetic */ DebuggerClassNameProvider this$0;
                final /* synthetic */ Ref.BooleanRef $isSuccess;
                final /* synthetic */ Runnable $task;
                final /* synthetic */ String $functionName;

                public final void run() {
                    this.$isSuccess.element = ProgressManager.getInstance().runProcessWithProgressSynchronously(this.$task, "Compute class names for function " + this.$functionName, true, this.this$0.getMyDebugProcess().getProject());
                }
                {
                    this.this$0 = debuggerClassNameProvider;
                    this.$isSuccess = booleanRef;
                    this.$task = runnable;
                    this.$functionName = string;
                }
            }, ModalityState.NON_MODAL);
        } else {
            task2.run();
        }
        if (!isSuccess.element) {
            XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("Debugger can skip some executions of " + functionName2 + " method, because the computation of class names was interrupted", MessageType.WARNING).notify(this.myDebugProcess.getProject());
        }
        Iterable iterable = searchResult;
        void var9_9 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtElement it = (KtElement)element$iv$iv;
            Iterable list$iv$iv = this.classNamesForPosition((PsiElement)it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Set<String> findCrossInlineArguments(KtFunction argument2, ValueParameterDescriptor parameterDescriptor, BindingContext context) {
        return (Set)ApplicationUtilsKt.runReadAction((Function0)new Function0<Set<? extends String>>(this, parameterDescriptor, argument2, context){
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ ValueParameterDescriptor $parameterDescriptor;
            final /* synthetic */ KtFunction $argument;
            final /* synthetic */ BindingContext $context;

            @NotNull
            public final Set<String> invoke() {
                String functionName2;
                KtParameter source;
                KtCallableDeclaration ktCallableDeclaration;
                PsiElement psiElement = KotlinSourceElementKt.getPsi(this.$parameterDescriptor.getOriginal().getSource());
                if (!(psiElement instanceof KtParameter)) {
                    psiElement = null;
                }
                String string = (ktCallableDeclaration = (source = (KtParameter)psiElement)) != null && (ktCallableDeclaration = ((KtParameter)ktCallableDeclaration).getOwnerFunction()) != null ? ktCallableDeclaration.getName() : (functionName2 = null);
                if (functionName2 != null) {
                    return SetsKt.setOf((Object)DebuggerClassNameProvider.access$getCrossInlineArgumentClassName(this.this$0, this.$argument, functionName2, this.$context));
                }
                return SetsKt.emptySet();
            }
            {
                this.this$0 = debuggerClassNameProvider;
                this.$parameterDescriptor = valueParameterDescriptor;
                this.$argument = ktFunction;
                this.$context = bindingContext2;
                super(0);
            }
        });
    }

    private final String getCrossInlineArgumentClassName(KtFunction argument2, String inlineFunctionName, BindingContext context) {
        String anonymousClassNameForArgument = CodegenBinding.asmTypeForAnonymousClass(context, argument2).getInternalName();
        String newName2 = this.substringIndex(anonymousClassNameForArgument) + "$inlined" + "$" + inlineFunctionName;
        return newName2 + "$" + "*";
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ValueParameterDescriptor> containsCrossInlineParameterUsages(@NotNull KtElement $receiver, BindingContext context) {
        void $receiver$iv$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Object v0;
        Object element$iv2;
        block6: {
            void $receiver$iv2;
            containsCrossInlineParameterUsages.1 hasParameterCall$ = containsCrossInlineParameterUsages.1.INSTANCE;
            Sequence<PsiElement> sequence2 = PsiUtilsKt.getParents((PsiElement)$receiver);
            for (Object element$iv2 : $receiver$iv2) {
                if (!(element$iv2 instanceof KtNamedFunction)) continue;
                v0 = element$iv2;
                break block6;
            }
            v0 = null;
        }
        KtNamedFunction ktNamedFunction = v0;
        if (ktNamedFunction == null) {
            return SetsKt.emptySet();
        }
        KtNamedFunction inlineFunction = ktNamedFunction;
        SimpleFunctionDescriptor inlineFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, inlineFunction);
        if (inlineFunctionDescriptor == null || !InlineUtil.isInline(inlineFunctionDescriptor)) {
            return SetsKt.emptySet();
        }
        Iterable iterable = inlineFunctionDescriptor.getValueParameters();
        element$iv2 = $receiver$iv;
        Collection $i$f$firstIsInstanceOrNull = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            if (!it.isCrossinline()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable iterable2 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ValueParameterDescriptor valueParameterDescriptor;
            KtParameter psiParameter;
            Object element$iv$iv = element$iv$iv$iv;
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            PsiElement psiElement = KotlinSourceElementKt.getPsi(it.getSource());
            if (!(psiElement instanceof KtParameter)) {
                psiElement = null;
            }
            if (((psiParameter = (KtParameter)psiElement) != null && containsCrossInlineParameterUsages.1.INSTANCE.invoke($receiver, psiParameter) ? it : (ValueParameterDescriptor)null) == null) continue;
            valueParameterDescriptor = valueParameterDescriptor;
            ValueParameterDescriptor it$iv$iv = valueParameterDescriptor;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> classNamesForCrossInlineParameters(Collection<? extends ValueParameterDescriptor> usedParameters, BindingContext context) {
        void $receiver$iv;
        ValueParameterDescriptor parameter = (ValueParameterDescriptor)CollectionsKt.first((Iterable)usedParameters);
        HashSet result2 = SetsKt.hashSetOf((Object[])new String[0]);
        PsiElement psiElement = KotlinSourceElementKt.getPsi(parameter.getContainingDeclaration().getSource());
        if (!(psiElement instanceof KtNamedFunction)) {
            psiElement = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement;
        if (ktNamedFunction == null) {
            return SetsKt.emptySet();
        }
        KtNamedFunction inlineFunction = ktNamedFunction;
        Iterable iterable = (Iterable)ReferencesSearch.search((PsiElement)inlineFunction, (SearchScope)((SearchScope)this.getScopeForInlineFunctionUsages(inlineFunction)));
        for (Object element$iv : $receiver$iv) {
            PsiReference it = (PsiReference)element$iv;
            ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(it, this, context, parameter, result2, inlineFunction){
                final /* synthetic */ PsiReference $it;
                final /* synthetic */ DebuggerClassNameProvider this$0;
                final /* synthetic */ BindingContext $context$inlined;
                final /* synthetic */ ValueParameterDescriptor $parameter$inlined;
                final /* synthetic */ HashSet $result$inlined;
                final /* synthetic */ KtNamedFunction $inlineFunction$inlined;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void invoke() {
                    Object v7;
                    Object object;
                    block3: {
                        void $receiver$iv;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                        if (UtilsKt.isImportUsage(this.$it)) return;
                        PsiElement psiElement = this.$it.getElement();
                        if (!(psiElement instanceof KtExpression)) {
                            psiElement = null;
                        }
                        KtExpression ktExpression = (KtExpression)psiElement;
                        if (ktExpression == null) return;
                        KtExpression ktExpression2 = ktExpression;
                        KtExpression it = ktExpression2;
                        KtExpression ktExpression3 = KtPsiUtil.getParentCallIfPresent(it);
                        KtExpression call = ktExpression3;
                        if (call == null) return;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall(call, this.$context$inlined);
                        object = resolvedCall3;
                        if (resolvedCall3 == null) return;
                        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = object.getValueArguments();
                        object = map2;
                        if (map2 == null) return;
                        Set<Map.Entry<K, V>> set = object.entrySet();
                        object = set;
                        if (set == null) return;
                        Iterable $i$a$1$let = (Iterable)object;
                        for (T element$iv : $receiver$iv) {
                            Map.Entry it2 = (Map.Entry)element$iv;
                            if (!Intrinsics.areEqual((Object)((ValueParameterDescriptor)it2.getKey()).getOriginal(), (Object)this.$parameter$inlined)) continue;
                            v7 = element$iv;
                            break block3;
                        }
                        v7 = null;
                    }
                    Map.Entry entry = v7;
                    object = entry;
                    if (entry == null) return;
                    ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)object.getValue();
                    ResolvedValueArgument argument2 = resolvedValueArgument;
                    if (argument2 == null) return;
                    ValueArgument valueArgument = (ValueArgument)CollectionsKt.first(argument2.getArguments());
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"argument.arguments.first()");
                    KtExpression argumentExpression = DebuggerClassNameProvider.access$getArgumentExpression(this.this$0, valueArgument);
                    if (!(argumentExpression instanceof KtFunction)) return;
                    KtFunction ktFunction = (KtFunction)argumentExpression;
                    String string = this.$inlineFunction$inlined.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inlineFunction.name!!");
                    this.$result$inlined.add(DebuggerClassNameProvider.access$getCrossInlineArgumentClassName(this.this$0, ktFunction, string, this.$context$inlined));
                }
                {
                    this.$it = psiReference;
                    this.this$0 = debuggerClassNameProvider;
                    this.$context$inlined = bindingContext2;
                    this.$parameter$inlined = valueParameterDescriptor;
                    this.$result$inlined = hashSet;
                    this.$inlineFunction$inlined = ktNamedFunction;
                    super(0);
                }
            });
        }
        return result2;
    }

    private final GlobalSearchScope getScopeForInlineFunctionUsages(KtNamedFunction inlineFunction) {
        VirtualFile virtualFile2 = (VirtualFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<VirtualFile>(inlineFunction){
            final /* synthetic */ KtNamedFunction $inlineFunction;

            public final VirtualFile invoke() {
                return this.$inlineFunction.getContainingFile().getVirtualFile();
            }
            {
                this.$inlineFunction = ktNamedFunction;
                super(0);
            }
        });
        if (virtualFile2 != null) {
            Project project = this.myDebugProcess.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myDebugProcess.project");
            if (ProjectRootsUtil.isLibraryFile(project, virtualFile2)) {
                Collection $receiver$iv = this.scopes;
                Collection collection = $receiver$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[thisCollection$iv.size()]);
                if (globalSearchScopeArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])((Object[])globalSearchScopeArray)));
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.union(scopes.toTypedArray())");
                return globalSearchScope;
            }
        }
        GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
        return globalSearchScope;
    }

    private final KtExpression getArgumentExpression(ValueArgument it) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = it.getArgumentExpression();
        if (!(ktExpression2 instanceof KtLambdaExpression)) {
            ktExpression2 = null;
        }
        return (ktExpression = (KtLambdaExpression)ktExpression2) != null && (ktExpression = ktExpression.getFunctionLiteral()) != null ? (KtExpression)ktExpression : it.getArgumentExpression();
    }

    private final String substringIndex(@NotNull String $receiver) {
        boolean bl;
        block3: {
            if (StringsKt.lastIndexOf$default((CharSequence)$receiver, (String)"$", (int)0, (boolean)false, (int)6, null) < 0) {
                return $receiver;
            }
            String suffix = StringsKt.substringAfterLast$default((String)$receiver, (String)"$", null, (int)2, null);
            CharSequence $receiver$iv = suffix;
            CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
            while (charIterator.hasNext()) {
                char element$iv;
                char p1;
                char c = p1 = (element$iv = charIterator.nextChar());
                if (Character.isDigit(c)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            return StringsKt.substringBeforeLast$default((String)$receiver, (String)"$", null, (int)2, null) + "$";
        }
        return $receiver;
    }

    @NotNull
    public final DebugProcess getMyDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public final List<GlobalSearchScope> getScopes() {
        return this.scopes;
    }

    /*
     * WARNING - void declaration
     */
    public DebuggerClassNameProvider(@NotNull DebugProcess myDebugProcess, @NotNull List<? extends GlobalSearchScope> scopes) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        this.myDebugProcess = myDebugProcess;
        this.scopes = scopes;
        Class[] classArray = new Class[]{KtClass.class, KtObjectDeclaration.class, KtEnumEntry.class, KtFunctionLiteral.class, KtNamedFunction.class, KtPropertyAccessor.class, KtProperty.class, KtClassInitializer.class};
        DebuggerClassNameProvider debuggerClassNameProvider = this;
        Object[] objectArray = (Object[])elements$iv;
        debuggerClassNameProvider.TYPES_TO_CALCULATE_CLASSNAME = (Class[])objectArray;
    }

    @NotNull
    public static final /* synthetic */ KotlinDebuggerCaches.ComputedClassNames access$getInternalClassNameForElement(DebuggerClassNameProvider $this, @NotNull KtElement element2, @NotNull KotlinTypeMapper typeMapper, @NotNull KtFile file2, boolean isInLibrary, boolean withInlines) {
        return $this.getInternalClassNameForElement(element2, typeMapper, file2, isInLibrary, withInlines);
    }

    @Nullable
    public static final /* synthetic */ KtElement access$getElementToCalculateClassName(DebuggerClassNameProvider $this, @Nullable PsiElement notPositionedElement) {
        return $this.getElementToCalculateClassName(notPositionedElement);
    }

    @NotNull
    public static final /* synthetic */ Collection access$containsCrossInlineParameterUsages(DebuggerClassNameProvider $this, @NotNull KtElement $receiver, @NotNull BindingContext context) {
        return $this.containsCrossInlineParameterUsages($receiver, context);
    }

    @Nullable
    public static final /* synthetic */ String access$getJvmInternalNameForImpl(DebuggerClassNameProvider $this, @NotNull KotlinTypeMapper typeMapper, @NotNull KtClassOrObject ktClass) {
        return $this.getJvmInternalNameForImpl(typeMapper, ktClass);
    }

    @NotNull
    public static final /* synthetic */ Class[] access$getTYPES_TO_CALCULATE_CLASSNAME$p(DebuggerClassNameProvider $this) {
        return $this.TYPES_TO_CALCULATE_CLASSNAME;
    }

    @NotNull
    public static final /* synthetic */ GlobalSearchScope access$getScopeForInlineFunctionUsages(DebuggerClassNameProvider $this, @NotNull KtNamedFunction inlineFunction) {
        return $this.getScopeForInlineFunctionUsages(inlineFunction);
    }

    @NotNull
    public static final /* synthetic */ String access$getCrossInlineArgumentClassName(DebuggerClassNameProvider $this, @NotNull KtFunction argument2, @NotNull String inlineFunctionName, @NotNull BindingContext context) {
        return $this.getCrossInlineArgumentClassName(argument2, inlineFunctionName, context);
    }

    @Nullable
    public static final /* synthetic */ KtExpression access$getArgumentExpression(DebuggerClassNameProvider $this, @NotNull ValueArgument it) {
        return $this.getArgumentExpression(it);
    }
}

