/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.MethodInliner;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class FieldRemapper {
    protected FieldRemapper parent;
    private final String lambdaInternalName;
    private final Parameters params;

    public FieldRemapper(@Nullable String lambdaInternalName, @Nullable FieldRemapper parent2, @NotNull Parameters methodParams) {
        if (methodParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodParams", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "<init>"));
        }
        this.lambdaInternalName = lambdaInternalName;
        this.parent = parent2;
        this.params = methodParams;
    }

    protected boolean canProcess(@NotNull String fieldOwner, @NotNull String fieldName, boolean isFolding) {
        if (fieldOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldOwner", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "canProcess"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "canProcess"));
        }
        return fieldOwner.equals(this.getLambdaInternalName()) && InlineCodegenUtil.isCapturedFieldName(fieldName);
    }

    @Nullable
    public AbstractInsnNode foldFieldAccessChainIfNeeded(@NotNull List<AbstractInsnNode> capturedFieldAccess, @NotNull MethodNode node) {
        if (capturedFieldAccess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capturedFieldAccess", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "foldFieldAccessChainIfNeeded"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "foldFieldAccessChainIfNeeded"));
        }
        if (capturedFieldAccess.size() == 1) {
            return null;
        }
        return this.foldFieldAccessChainIfNeeded(capturedFieldAccess, 1, node);
    }

    public boolean processNonAload0FieldAccessChains(boolean isInlinedLambda) {
        return false;
    }

    @Nullable
    private AbstractInsnNode foldFieldAccessChainIfNeeded(@NotNull List<AbstractInsnNode> capturedFieldAccess, int currentInstruction, @NotNull MethodNode node) {
        AbstractInsnNode transformed2;
        boolean checkParent;
        if (capturedFieldAccess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capturedFieldAccess", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "foldFieldAccessChainIfNeeded"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "foldFieldAccessChainIfNeeded"));
        }
        boolean bl = checkParent = !this.isRoot() && currentInstruction < capturedFieldAccess.size() - 1;
        if (checkParent && (transformed2 = this.parent.foldFieldAccessChainIfNeeded(capturedFieldAccess, currentInstruction + 1, node)) != null) {
            return transformed2;
        }
        FieldInsnNode insnNode = (FieldInsnNode)capturedFieldAccess.get(currentInstruction);
        if (this.canProcess(insnNode.owner, insnNode.name, true)) {
            insnNode.name = "$$$" + insnNode.name;
            insnNode.setOpcode(178);
            for (AbstractInsnNode next2 = capturedFieldAccess.get(0); next2 != insnNode; next2 = next2.getNext()) {
                AbstractInsnNode toDelete = next2;
                node.instructions.remove(toDelete);
            }
            return capturedFieldAccess.get(capturedFieldAccess.size() - 1);
        }
        return null;
    }

    @Nullable
    public CapturedParamInfo findField(@NotNull FieldInsnNode fieldInsnNode) {
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "findField"));
        }
        return this.findField(fieldInsnNode, this.params.getCaptured());
    }

    @Nullable
    protected CapturedParamInfo findField(@NotNull FieldInsnNode fieldInsnNode, @NotNull Collection<CapturedParamInfo> captured) {
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "findField"));
        }
        if (captured == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captured", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "findField"));
        }
        for (CapturedParamInfo valueDescriptor : captured) {
            if (!valueDescriptor.getOriginalFieldName().equals(fieldInsnNode.name) || !valueDescriptor.getContainingLambdaName().equals(fieldInsnNode.owner)) continue;
            return valueDescriptor;
        }
        return null;
    }

    @NotNull
    public FieldRemapper getParent() {
        FieldRemapper fieldRemapper = this.parent;
        if (fieldRemapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "getParent"));
        }
        return fieldRemapper;
    }

    public String getLambdaInternalName() {
        return this.lambdaInternalName;
    }

    public String getNewLambdaInternalName() {
        return this.lambdaInternalName;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Nullable
    public StackValue getFieldForInline(@NotNull FieldInsnNode node, @Nullable StackValue prefix) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/FieldRemapper", "getFieldForInline"));
        }
        return MethodInliner.findCapturedField(node, this).getRemapValue();
    }

    public boolean isInsideInliningLambda() {
        return !this.isRoot() && this.parent.isInsideInliningLambda();
    }
}

