/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MouseInputListener;

public class MouseEventAdapter<T>
extends MouseAdapter
implements MouseInputListener {
    private final T myAdapter;

    public MouseEventAdapter(T adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseEntered(this.convert(event));
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mousePressed(this.convert(event));
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseClicked(this.convert(event));
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseReleased(this.convert(event));
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseExited(this.convert(event));
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        MouseMotionListener listener = this.getMouseMotionListener(this.myAdapter);
        if (listener != null) {
            listener.mouseMoved(this.convert(event));
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        MouseMotionListener listener = this.getMouseMotionListener(this.myAdapter);
        if (listener != null) {
            listener.mouseDragged(this.convert(event));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        MouseWheelListener listener = this.getMouseWheelListener(this.myAdapter);
        if (listener != null) {
            listener.mouseWheelMoved(this.convert(event));
        }
    }

    protected MouseListener getMouseListener(T adapter) {
        return adapter instanceof MouseListener ? (MouseListener)adapter : null;
    }

    protected MouseMotionListener getMouseMotionListener(T adapter) {
        return adapter instanceof MouseMotionListener ? (MouseMotionListener)adapter : null;
    }

    protected MouseWheelListener getMouseWheelListener(T adapter) {
        return adapter instanceof MouseWheelListener ? (MouseWheelListener)adapter : null;
    }

    protected MouseEvent convert(MouseEvent event) {
        return event;
    }

    protected MouseWheelEvent convert(MouseWheelEvent event) {
        return event;
    }

    public static MouseEvent convert(MouseEvent event, Component source) {
        Point point = event.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, source);
        return MouseEventAdapter.convert(event, source, point.x, point.y);
    }

    public static MouseEvent convert(MouseEvent event, Component source, int x, int y) {
        return MouseEventAdapter.convert(event, source, event.getID(), event.getWhen(), event.getModifiers() | event.getModifiersEx(), x, y);
    }

    public static MouseEvent convert(MouseEvent event, Component source, int id, long when, int modifiers, int x, int y) {
        if (event instanceof MouseWheelEvent) {
            return MouseEventAdapter.convert((MouseWheelEvent)event, source, id, when, modifiers, x, y);
        }
        if (event instanceof MenuDragMouseEvent) {
            return MouseEventAdapter.convert((MenuDragMouseEvent)event, source, id, when, modifiers, x, y);
        }
        return new MouseEvent(source, id, when, modifiers, x, y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
    }

    public static MouseWheelEvent convert(MouseWheelEvent event, Component source, int id, long when, int modifiers, int x, int y) {
        return new MouseWheelEvent(source, id, when, modifiers, x, y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getScrollType(), event.getScrollAmount(), event.getWheelRotation());
    }

    public static MenuDragMouseEvent convert(MenuDragMouseEvent event, Component source, int id, long when, int modifiers, int x, int y) {
        return new MenuDragMouseEvent(source, id, when, modifiers, x, y, event.getClickCount(), event.isPopupTrigger(), event.getPath(), event.getMenuSelectionManager());
    }
}

