/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGTests;

public class SVGSwitchElementBridge
extends SVGGElementBridge {
    protected Element selectedChild;

    @Override
    public String getLocalName() {
        return "switch";
    }

    @Override
    public Bridge getInstance() {
        return new SVGSwitchElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        GraphicsNode graphicsNode = null;
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        this.selectedChild = null;
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1) continue;
            Element element2 = (Element)object;
            if (!(object instanceof SVGTests) || !SVGUtilities.matchUserAgent(element2, bridgeContext.getUserAgent())) continue;
            this.selectedChild = element2;
            graphicsNode = gVTBuilder.build(bridgeContext, element2);
            break;
        }
        if (graphicsNode == null) {
            return null;
        }
        object = (CompositeGraphicsNode)super.createGraphicsNode(bridgeContext, element);
        if (object == null) {
            return null;
        }
        ((CompositeGraphicsNode)object).add(graphicsNode);
        return object;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void dispose() {
        this.selectedChild = null;
        super.dispose();
    }

    @Override
    protected void handleElementAdded(CompositeGraphicsNode compositeGraphicsNode, Node node, Element element) {
        Object object;
        for (object = element.getPreviousSibling(); object != null; object = object.getPreviousSibling()) {
            if (object != element) continue;
            return;
        }
        if (element instanceof SVGTests && SVGUtilities.matchUserAgent(element, this.ctx.getUserAgent())) {
            if (this.selectedChild != null) {
                compositeGraphicsNode.remove(0);
                this.disposeTree(this.selectedChild);
            }
            this.selectedChild = element;
            object = this.ctx.getGVTBuilder();
            GraphicsNode graphicsNode = ((GVTBuilder)object).build(this.ctx, element);
            if (graphicsNode != null) {
                compositeGraphicsNode.add(graphicsNode);
            }
        }
    }

    protected void handleChildElementRemoved(Element element) {
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)this.node;
        if (this.selectedChild == element) {
            compositeGraphicsNode.remove(0);
            this.disposeTree(this.selectedChild);
            this.selectedChild = null;
            GraphicsNode graphicsNode = null;
            GVTBuilder gVTBuilder = this.ctx.getGVTBuilder();
            for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                if (!(node instanceof SVGTests) || !SVGUtilities.matchUserAgent(element2, this.ctx.getUserAgent())) continue;
                graphicsNode = gVTBuilder.build(this.ctx, element2);
                this.selectedChild = element2;
                break;
            }
            if (graphicsNode != null) {
                compositeGraphicsNode.add(graphicsNode);
            }
        }
    }
}

