/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.idea.maven.model.MavenArchetype;

public class MavenAddArchetypeDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myGroupIdField;
    private JTextField myArtifactIdField;
    private JTextField myVersionField;
    private JTextField myRepositoryField;

    public MavenAddArchetypeDialog(Component parent) {
        super(parent, false);
        this.$$$setupUI$$$();
        this.setTitle("Add Archetype");
        this.init();
        DocumentAdapter l = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MavenAddArchetypeDialog.this.doValidateInput();
            }
        };
        this.myGroupIdField.getDocument().addDocumentListener((DocumentListener)l);
        this.myArtifactIdField.getDocument().addDocumentListener((DocumentListener)l);
        this.myVersionField.getDocument().addDocumentListener((DocumentListener)l);
        this.myRepositoryField.getDocument().addDocumentListener((DocumentListener)l);
        this.doValidateInput();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupIdField;
    }

    protected String getHelpId() {
        return "Add_Archetype_Dialog";
    }

    private void doValidateInput() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmptyOrSpaces((String)this.myGroupIdField.getText())) {
            errors.add("GroupId");
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myArtifactIdField.getText())) {
            errors.add("ArtifactId");
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myVersionField.getText())) {
            errors.add("Version");
        }
        if (errors.isEmpty()) {
            this.setErrorText(null);
            this.getOKAction().setEnabled(true);
            return;
        }
        String message = "Please specify " + StringUtil.join(errors, (String)", ");
        this.setErrorText(message);
        this.getOKAction().setEnabled(false);
        this.getRootPane().revalidate();
    }

    public MavenArchetype getArchetype() {
        return new MavenArchetype(this.myGroupIdField.getText(), this.myArtifactIdField.getText(), this.myVersionField.getText(), this.myRepositoryField.getText(), null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("GroupId");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGroupIdField = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("ArtifactId");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myArtifactIdField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Version");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("<html>Repository <i>(optional)</i></html>");
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRepositoryField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

