/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.vfs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class MavenPropertiesVirtualFile
extends VirtualFile {
    private final String myPath;
    private final VirtualFileSystem myFS;
    private final byte[] myContent;

    public MavenPropertiesVirtualFile(String path, Properties properties, VirtualFileSystem FS) {
        this.myPath = path;
        this.myFS = FS;
        this.myContent = MavenPropertiesVirtualFile.createContent(properties);
    }

    private static byte[] createContent(Properties properties) {
        StringBuilder builder = new StringBuilder();
        TreeSet<Object> sortedKeys = new TreeSet<Object>(properties.keySet());
        for (String string : sortedKeys) {
            builder.append(StringUtil.escapeProperty((String)string, (boolean)true));
            builder.append("=");
            builder.append(StringUtil.escapeProperty((String)properties.getProperty(string), (boolean)false));
            builder.append("\n");
        }
        return builder.toString().getBytes();
    }

    @NotNull
    public String getName() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFile", "getName"));
        }
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFS;
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFile", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myContent == null) {
            throw new IOException();
        }
        if (this.myContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFile", "contentsToByteArray"));
        }
        return this.myContent;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public long getModificationStamp() {
        return Arrays.hashCode(this.myContent);
    }

    public long getLength() {
        return this.myContent.length;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM((byte[])this.myContent, (VirtualFile)this);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }
}

