/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.groovy;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import icons.MavenIcons;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class MavenGroovyPomScriptType
extends GroovyRunnableScriptType {
    public static final MavenGroovyPomScriptType INSTANCE = new MavenGroovyPomScriptType();

    public MavenGroovyPomScriptType() {
        super("pom");
    }

    @NotNull
    public Icon getScriptIcon() {
        Icon icon = MavenIcons.MavenLogo;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomScriptType", "getScriptIcon"));
        }
        return icon;
    }

    public GlobalSearchScope patchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomScriptType", "patchResolveScope"));
        }
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomScriptType", "patchResolveScope"));
        }
        return this.doPatchResolveScope(file, baseScope);
    }

    public GlobalSearchScope doPatchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomScriptType", "doPatchResolveScope"));
        }
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomScriptType", "doPatchResolveScope"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return baseScope;
        }
        Project project = module.getProject();
        GlobalSearchScope result = baseScope;
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)file.getProject());
        Boolean hasGroovyModuleLib = (Boolean)cachedValuesManager.getCachedValue((UserDataHolder)file.getProject(), () -> CachedValueProvider.Result.createSingleDependency((Object)MavenGroovyPomScriptType.hasModuleWithGroovyLibrary(project), (Object)ProjectRootManagerEx.getInstanceEx((Project)project)));
        if (hasGroovyModuleLib.booleanValue()) {
            List<VirtualFile> files = MavenGroovyPomScriptType.additionalScopeFiles();
            result = result.uniteWith((GlobalSearchScope)new NonClasspathDirectoriesScope(files));
        }
        return result;
    }

    public static List<VirtualFile> additionalScopeFiles() {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)GroovyFacetUtil.getBundledGroovyJar(), (boolean)false);
        return virtualFile == null ? ContainerUtil.emptyList() : ContainerUtil.list((Object[])new VirtualFile[]{StandardFileSystems.getJarRootForLocalFile((VirtualFile)virtualFile)});
    }

    private static boolean hasModuleWithGroovyLibrary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/plugins/groovy/MavenGroovyPomScriptType", "hasModuleWithGroovyLibrary"));
        }
        Iterator iterator = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraryIterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
                List orderEntries;
                if (!GroovyConfigUtils.GROOVY_JAR_PATTERN.matcher(virtualFile.getName()).matches() && !GroovyConfigUtils.matchesGroovyAll((String)virtualFile.getName()) || (orderEntries = ProjectFileIndex.SERVICE.getInstance((Project)project).getOrderEntriesForFile(virtualFile)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

