/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;

public class MavenProjectModelModifier
extends JavaProjectModelModifier {
    private final Project myProject;
    private final MavenProjectsManager myProjectsManager;
    private MavenProjectIndicesManager myIndicesManager;

    public MavenProjectModelModifier(Project project, MavenProjectsManager projectsManager, MavenProjectIndicesManager manager) {
        this.myProject = project;
        this.myProjectsManager = projectsManager;
        this.myIndicesManager = manager;
    }

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addModuleDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addModuleDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addModuleDependency"));
        }
        MavenProject toProject = this.myProjectsManager.findProject(to);
        if (toProject == null) {
            return null;
        }
        MavenId mavenId = toProject.getMavenId();
        return this.addDependency(Collections.singletonList(from), mavenId, scope);
    }

    private Promise<Void> addDependency(@NotNull Collection<Module> fromModules, @NotNull MavenId mavenId, @NotNull DependencyScope scope) {
        if (fromModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromModules", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        if (mavenId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        return this.addDependency(fromModules, mavenId, null, null, scope);
    }

    private Promise<Void> addDependency(@NotNull Collection<Module> fromModules, @NotNull MavenId mavenId, @Nullable String minVersion, @Nullable String maxVersion, @NotNull DependencyScope scope) {
        if (fromModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromModules", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        if (mavenId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        final ArrayList<Trinity> models = new ArrayList<Trinity>(fromModules.size());
        ArrayList<XmlFile> files = new ArrayList<XmlFile>(fromModules.size());
        ArrayList<MavenProject> projectToUpdate = new ArrayList<MavenProject>(fromModules.size());
        String mavenScope = MavenProjectModelModifier.getMavenScope(scope);
        for (Module from : fromModules) {
            if (!this.myProjectsManager.isMavenizedModule(from)) {
                return null;
            }
            MavenProject fromProject = this.myProjectsManager.findProject(from);
            if (fromProject == null) {
                return null;
            }
            MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(this.myProject, fromProject.getFile());
            if (model == null) {
                return null;
            }
            String scopeToSet = null;
            String version = null;
            if (mavenId.getGroupId() != null && mavenId.getArtifactId() != null) {
                MavenDomDependency managedDependency = MavenDependencyCompletionUtil.findManagedDependency(model, this.myProject, mavenId.getGroupId(), mavenId.getArtifactId());
                if (managedDependency != null) {
                    String managedScope = StringUtil.nullize((String)managedDependency.getScope().getStringValue(), (boolean)true);
                    String string = scopeToSet = managedScope == null && "compile".equals(mavenScope) || StringUtil.equals((CharSequence)managedScope, (CharSequence)mavenScope) ? null : mavenScope;
                }
                if (managedDependency == null || StringUtil.isEmpty((String)managedDependency.getVersion().getStringValue())) {
                    version = this.selectVersion(mavenId, minVersion, maxVersion);
                }
            }
            models.add(Trinity.create((Object)model, (Object)new MavenId(mavenId.getGroupId(), mavenId.getArtifactId(), version), scopeToSet));
            files.add(DomUtil.getFile((DomElement)model));
            projectToUpdate.add(fromProject);
        }
        new WriteCommandAction(this.myProject, "Add Maven Dependency", PsiUtilCore.toPsiFileArray(files)){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier$1", "run"));
                }
                for (Trinity trinity : models) {
                    Document document;
                    MavenDomProjectModel model = (MavenDomProjectModel)trinity.first;
                    MavenDomDependency dependency = MavenDomUtil.createDomDependency(model, null, (MavenId)trinity.second);
                    String mavenScope = (String)trinity.third;
                    if (mavenScope != null) {
                        dependency.getScope().setStringValue(mavenScope);
                    }
                    if ((document = PsiDocumentManager.getInstance((Project)MavenProjectModelModifier.this.myProject).getDocument((PsiFile)DomUtil.getFile((DomElement)model))) == null) continue;
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            }
        }.execute();
        return this.myProjectsManager.forceUpdateProjects(projectToUpdate);
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addExternalLibraryDependency"));
        }
        for (Module module : modules) {
            if (this.myProjectsManager.isMavenizedModule(module)) continue;
            return null;
        }
        MavenId mavenId = new MavenId(descriptor.getLibraryGroupId(), descriptor.getLibraryArtifactId(), null);
        return this.addDependency(modules, mavenId, descriptor.getMinVersion(), descriptor.getMaxVersion(), scope);
    }

    @NotNull
    private String selectVersion(@NotNull MavenId mavenId, @Nullable String minVersion, @Nullable String maxVersion) {
        if (mavenId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "selectVersion"));
        }
        Set<String> versions = this.myIndicesManager.getVersions(mavenId.getGroupId(), mavenId.getArtifactId());
        ArrayList<String> suitableVersions = new ArrayList<String>();
        for (String version : versions) {
            if (minVersion != null && VersionComparatorUtil.compare((String)minVersion, (String)version) > 0 || maxVersion != null && VersionComparatorUtil.compare((String)version, (String)maxVersion) > 0) continue;
            suitableVersions.add(version);
        }
        String string = suitableVersions.isEmpty() ? "RELEASE" : (String)Collections.max(suitableVersions, VersionComparatorUtil.COMPARATOR);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "selectVersion"));
        }
        return string;
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addLibraryDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addLibraryDependency"));
        }
        String name = library.getName();
        if (name != null && name.startsWith("Maven: ")) {
            String mavenCoordinates = StringUtil.trimStart((String)name, (String)"Maven: ");
            return this.addDependency(Collections.singletonList(from), RepositoryAttachHandler.getMavenId(mavenCoordinates), scope);
        }
        return null;
    }

    public Promise<Void> changeLanguageLevel(@NotNull Module module, final @NotNull LanguageLevel level) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "changeLanguageLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "changeLanguageLevel"));
        }
        if (!this.myProjectsManager.isMavenizedModule(module)) {
            return null;
        }
        MavenProject mavenProject = this.myProjectsManager.findProject(module);
        if (mavenProject == null) {
            return null;
        }
        final MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile());
        if (model == null) {
            return null;
        }
        new WriteCommandAction(this.myProject, "Add Maven Dependency", new PsiFile[]{DomUtil.getFile((DomElement)model)}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier$2", "run"));
                }
                MavenDomConfiguration configuration = MavenProjectModelModifier.getCompilerPlugin(model).getConfiguration();
                XmlTag tag = configuration.ensureTagExists();
                MavenProjectModelModifier.setChildTagValue(tag, "source", level.getCompilerComplianceDefaultOption());
                MavenProjectModelModifier.setChildTagValue(tag, "target", level.getCompilerComplianceDefaultOption());
                Document document = PsiDocumentManager.getInstance((Project)MavenProjectModelModifier.this.myProject).getDocument((PsiFile)DomUtil.getFile((DomElement)model));
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            }
        }.execute();
        return this.myProjectsManager.forceUpdateProjects(Collections.singleton(mavenProject));
    }

    private static void setChildTagValue(@NotNull XmlTag tag, @NotNull String subTagName, @NotNull String value) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "setChildTagValue"));
        }
        if (subTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subTagName", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "setChildTagValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "setChildTagValue"));
        }
        XmlTag subTag = tag.findFirstSubTag(subTagName);
        if (subTag != null) {
            subTag.getValue().setText(value);
        } else {
            tag.addSubTag(tag.createChildTag(subTagName, tag.getNamespace(), value, false), false);
        }
    }

    @NotNull
    private static MavenDomPlugin getCompilerPlugin(MavenDomProjectModel model) {
        MavenDomPlugins plugins = model.getBuild().getPlugins();
        for (MavenDomPlugin plugin : plugins.getPlugins()) {
            if (!"org.apache.maven.plugins".equals(plugin.getGroupId().getValue()) || !"maven-compiler-plugin".equals(plugin.getArtifactId().getValue())) continue;
            MavenDomPlugin mavenDomPlugin = plugin;
            if (mavenDomPlugin == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "getCompilerPlugin"));
            }
            return mavenDomPlugin;
        }
        MavenDomPlugin plugin = plugins.addPlugin();
        plugin.getGroupId().setValue((Object)"org.apache.maven.plugins");
        plugin.getArtifactId().setValue((Object)"maven-compiler-plugin");
        MavenDomPlugin mavenDomPlugin = plugin;
        if (mavenDomPlugin == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "getCompilerPlugin"));
        }
        return mavenDomPlugin;
    }

    @Nullable
    private static String getMavenScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "getMavenScope"));
        }
        switch (scope) {
            case RUNTIME: {
                return "runtime";
            }
            case COMPILE: {
                return "compile";
            }
            case TEST: {
                return "test";
            }
            case PROVIDED: {
                return "provided";
            }
        }
        return null;
    }
}

