/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.IntersectingLocalChangesPanel;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeContentsVariants;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.QuickMergeWayOptionsPanel;
import org.jetbrains.idea.svn.integrate.ToBeMergedDialog;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;

public class QuickMergeInteractionImpl
implements QuickMergeInteraction {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myTitle;

    public QuickMergeInteractionImpl(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "<init>"));
        }
        this.myMergeContext = mergeContext;
        this.myProject = mergeContext.getProject();
        this.myTitle = mergeContext.getTitle();
    }

    @Override
    @NotNull
    public QuickMergeContentsVariants selectMergeVariant() {
        QuickMergeWayOptionsPanel panel = new QuickMergeWayOptionsPanel();
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.title("Select Merge Variant").centerPanel((JComponent)panel.getMainPanel()).removeAllActions();
        panel.setWrapper(builder.getDialogWrapper());
        builder.show();
        QuickMergeContentsVariants quickMergeContentsVariants = panel.getVariant();
        if (quickMergeContentsVariants == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "selectMergeVariant"));
        }
        return quickMergeContentsVariants;
    }

    @Override
    public boolean shouldContinueSwitchedRootFound() {
        return this.prompt("There are some switched paths in the working copy. Do you want to continue?");
    }

    @Override
    public boolean shouldReintegrate(@NotNull String targetUrl) {
        if (targetUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetUrl", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "shouldReintegrate"));
        }
        return this.prompt("<html><body>You are going to reintegrate changes.<br><br>This will make branch '" + this.myMergeContext.getSourceUrl() + "' <b>no longer usable for further work</b>.<br>It will not be able to correctly absorb new trunk (" + targetUrl + ") changes,<br>nor can this branch be properly reintegrated to trunk again.<br><br>Are you sure?</body></html>");
    }

    @Override
    @NotNull
    public QuickMergeInteraction.SelectMergeItemsResult selectMergeItems(@NotNull List<CommittedChangeList> lists, @NotNull String mergeTitle, @NotNull MergeChecker mergeChecker) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "selectMergeItems"));
        }
        if (mergeTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeTitle", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "selectMergeItems"));
        }
        if (mergeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeChecker", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "selectMergeItems"));
        }
        final ToBeMergedDialog dialog = new ToBeMergedDialog(this.myMergeContext, lists, mergeTitle, mergeChecker, true);
        dialog.show();
        QuickMergeInteraction.SelectMergeItemsResult selectMergeItemsResult = new QuickMergeInteraction.SelectMergeItemsResult(){

            @Override
            @NotNull
            public QuickMergeContentsVariants getResultCode() {
                switch (dialog.getExitCode()) {
                    case 222: {
                        QuickMergeContentsVariants quickMergeContentsVariants = QuickMergeContentsVariants.all;
                        if (quickMergeContentsVariants == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl$1", "getResultCode"));
                        }
                        return quickMergeContentsVariants;
                    }
                    case 0: {
                        QuickMergeContentsVariants quickMergeContentsVariants = QuickMergeContentsVariants.select;
                        if (quickMergeContentsVariants == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl$1", "getResultCode"));
                        }
                        return quickMergeContentsVariants;
                    }
                }
                QuickMergeContentsVariants quickMergeContentsVariants = QuickMergeContentsVariants.cancel;
                if (quickMergeContentsVariants == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl$1", "getResultCode"));
                }
                return quickMergeContentsVariants;
            }

            @Override
            @NotNull
            public List<CommittedChangeList> getSelectedLists() {
                List<CommittedChangeList> list = dialog.getSelected();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl$1", "getSelectedLists"));
                }
                return list;
            }
        };
        if (selectMergeItemsResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "selectMergeItems"));
        }
        return selectMergeItemsResult;
    }

    @Override
    @NotNull
    public LocalChangesAction selectLocalChangesAction(boolean mergeAll) {
        String message;
        LocalChangesAction[] possibleResults;
        if (!mergeAll) {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.inspect, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = "There are local changes that will intersect with merge changes.\nDo you want to continue?";
        } else {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = "There are local changes that can potentially intersect with merge changes.\nDo you want to continue?";
        }
        int result = Messages.showDialog((String)message, (String)this.myTitle, (String[])((String[])ContainerUtil.map2Array((Object[])possibleResults, String.class, (Function)Functions.TO_STRING())), (int)0, (Icon)Messages.getQuestionIcon());
        LocalChangesAction localChangesAction = possibleResults[result];
        if (localChangesAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "selectLocalChangesAction"));
        }
        return localChangesAction;
    }

    @Override
    public void showIntersectedLocalPaths(@NotNull List<FilePath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "showIntersectedLocalPaths"));
        }
        IntersectingLocalChangesPanel.showInVersionControlToolWindow(this.myProject, this.myTitle + ", local changes intersection", paths, "The following file(s) have local changes that will intersect with merge changes:");
    }

    @Override
    public void showErrors(@NotNull String message, @NotNull List<VcsException> exceptions) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "showErrors"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "showErrors"));
        }
        AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, message);
    }

    @Override
    public void showErrors(@NotNull String message, boolean isError) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "showErrors"));
        }
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)message, (MessageType)(isError ? MessageType.ERROR : MessageType.WARNING), (NamedRunnable[])new NamedRunnable[0]);
    }

    @Override
    @NotNull
    public List<CommittedChangeList> showRecentListsForSelection(@NotNull List<CommittedChangeList> list, @NotNull MergeChecker mergeChecker, boolean everyThingLoaded) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "showRecentListsForSelection"));
        }
        if (mergeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeChecker", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "showRecentListsForSelection"));
        }
        ToBeMergedDialog dialog = new ToBeMergedDialog(this.myMergeContext, list, this.myMergeContext.getTitle(), mergeChecker, false);
        List<CommittedChangeList> list2 = dialog.showAndGet() ? dialog.getSelected() : ContainerUtil.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "showRecentListsForSelection"));
        }
        return list2;
    }

    private boolean prompt(@NotNull String question) {
        if (question == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "question", "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl", "prompt"));
        }
        return Messages.showOkCancelDialog((Project)this.myProject, (String)question, (String)this.myTitle, (Icon)Messages.getQuestionIcon()) == 0;
    }
}

