/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public abstract class AuthCallbackCase {
    protected final SVNURL myUrl;
    @NotNull
    protected final AuthenticationService myAuthenticationService;

    AuthCallbackCase(@NotNull AuthenticationService authenticationService, SVNURL url) {
        if (authenticationService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authenticationService", "org/jetbrains/idea/svn/commandLine/AuthCallbackCase", "<init>"));
        }
        this.myAuthenticationService = authenticationService;
        this.myUrl = url;
    }

    public abstract boolean canHandle(String var1);

    abstract boolean getCredentials(String var1) throws SvnBindException;

    public void updateParameters(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/AuthCallbackCase", "updateParameters"));
        }
    }

    protected SVNURL parseUrl(String urlValue) {
        try {
            return SVNURL.parseURIEncoded((String)urlValue);
        }
        catch (SVNException e) {
            return null;
        }
    }
}

