/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.incremental.artifacts.JpsSyntheticArtifactProvider;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.service.JpsServiceManager;

public class JpsBuilderArtifactServiceImpl
extends JpsBuilderArtifactService {
    private static final JpsElementCollectionRole<JpsArtifact> SYNTHETIC_ARTIFACTS = JpsElementCollectionRole.create((JpsElementChildRole)JpsElementChildRoleBase.create((String)"synthetic artifact"));

    @Override
    public Collection<JpsArtifact> getArtifacts(JpsModel model, boolean includeSynthetic) {
        List artifacts = JpsArtifactService.getInstance().getArtifacts(model.getProject());
        if (!includeSynthetic) {
            return artifacts;
        }
        return ContainerUtil.concat((List)artifacts, (List)this.getSyntheticArtifacts(model));
    }

    public List<JpsArtifact> getSyntheticArtifacts(JpsModel model) {
        JpsElementCollection artifactsCollection = (JpsElementCollection)model.getProject().getContainer().getChild(SYNTHETIC_ARTIFACTS);
        if (artifactsCollection == null) {
            List<JpsArtifact> artifactList = JpsBuilderArtifactServiceImpl.computeSyntheticArtifacts(model);
            artifactsCollection = (JpsElementCollection)model.getProject().getContainer().setChild(SYNTHETIC_ARTIFACTS);
            for (JpsArtifact artifact : artifactList) {
                artifactsCollection.addChild((JpsElement)artifact);
            }
        }
        return artifactsCollection.getElements();
    }

    private static List<JpsArtifact> computeSyntheticArtifacts(JpsModel model) {
        ArrayList<JpsArtifact> artifacts = new ArrayList<JpsArtifact>();
        for (JpsSyntheticArtifactProvider provider : JpsServiceManager.getInstance().getExtensions(JpsSyntheticArtifactProvider.class)) {
            artifacts.addAll(provider.createArtifacts(model));
        }
        return artifacts;
    }
}

