/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.requests;

import com.google.gson.annotations.SerializedName;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GithubGistRequest {
    @NotNull
    private final String description;
    @NotNull
    private final Map<String, GistFile> files;
    @SerializedName(value="public")
    private final boolean isPublic;

    public GithubGistRequest(@NotNull List<FileContent> files, @NotNull String description, boolean isPublic) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/plugins/github/api/requests/GithubGistRequest", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/api/requests/GithubGistRequest", "<init>"));
        }
        this.description = description;
        this.isPublic = isPublic;
        this.files = new HashMap();
        for (FileContent file : files) {
            this.files.put(file.getFileName(), new GistFile(file.getContent()));
        }
    }

    public static class FileContent {
        @NotNull
        private final String myFileName;
        @NotNull
        private final String myContent;

        public FileContent(@NotNull String fileName, @NotNull String content) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/github/api/requests/GithubGistRequest$FileContent", "<init>"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/github/api/requests/GithubGistRequest$FileContent", "<init>"));
            }
            this.myFileName = fileName;
            this.myContent = content;
        }

        @NotNull
        public String getFileName() {
            String string = this.myFileName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/requests/GithubGistRequest$FileContent", "getFileName"));
            }
            return string;
        }

        @NotNull
        public String getContent() {
            String string = this.myContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/requests/GithubGistRequest$FileContent", "getContent"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileContent that = (FileContent)o;
            if (!this.myContent.equals(that.myContent)) {
                return false;
            }
            return this.myFileName.equals(that.myFileName);
        }

        public int hashCode() {
            int result = this.myFileName.hashCode();
            result = 31 * result + this.myContent.hashCode();
            return result;
        }
    }

    public static class GistFile {
        @NotNull
        private final String content;

        public GistFile(@NotNull String content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/github/api/requests/GithubGistRequest$GistFile", "<init>"));
            }
            this.content = content;
        }
    }
}

