/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubIssue {
    private String url;
    @Mandatory
    private String htmlUrl;
    @Mandatory
    private Long number;
    @Mandatory
    private String state;
    @Mandatory
    private String title;
    private String body;
    @Mandatory
    private GithubUser user;
    private GithubUser assignee;
    private Date closedAt;
    @Mandatory
    private Date createdAt;
    @Mandatory
    private Date updatedAt;

    @NotNull
    public String getHtmlUrl() {
        String string = this.htmlUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubIssue", "getHtmlUrl"));
        }
        return string;
    }

    public long getNumber() {
        return this.number;
    }

    @NotNull
    public String getState() {
        String string = this.state;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubIssue", "getState"));
        }
        return string;
    }

    @NotNull
    public String getTitle() {
        String string = this.title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubIssue", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String getBody() {
        String string = StringUtil.notNullize((String)this.body);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubIssue", "getBody"));
        }
        return string;
    }

    @NotNull
    public GithubUser getUser() {
        GithubUser githubUser = this.user;
        if (githubUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubIssue", "getUser"));
        }
        return githubUser;
    }

    @Nullable
    public GithubUser getAssignee() {
        return this.assignee;
    }

    @Nullable
    public Date getClosedAt() {
        return this.closedAt;
    }

    @NotNull
    public Date getCreatedAt() {
        Date date = this.createdAt;
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubIssue", "getCreatedAt"));
        }
        return date;
    }

    @NotNull
    public Date getUpdatedAt() {
        Date date = this.updatedAt;
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubIssue", "getUpdatedAt"));
        }
        return date;
    }
}

