/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubOpenInBrowserAction;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubOpenCommitInBrowserFromAnnotateAction
extends GithubOpenInBrowserAction
implements UpToDateLineNumberListener {
    private final FileAnnotation myAnnotation;
    private int myLineNumber = -1;

    public GithubOpenCommitInBrowserFromAnnotateAction(FileAnnotation annotation) {
        this.myAnnotation = annotation;
    }

    @Override
    @Nullable
    protected GithubOpenInBrowserAction.CommitData getData(AnActionEvent e) {
        if (this.myLineNumber < 0) {
            return null;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(virtualFile);
        if (repository == null || !GithubUtil.isRepositoryOnGitHub(repository)) {
            return null;
        }
        VcsRevisionNumber revisionNumber = this.myAnnotation.getLineRevisionNumber(this.myLineNumber);
        return new GithubOpenInBrowserAction.CommitData(project, repository, revisionNumber != null ? revisionNumber.asString() : null);
    }

    public void consume(Integer integer) {
        this.myLineNumber = integer;
    }
}

