/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;

public class GrClassReferenceType
extends PsiClassType {
    private final GrReferenceElement myReferenceElement;

    public GrClassReferenceType(GrReferenceElement referenceElement) {
        super(LanguageLevel.JDK_1_5);
        this.myReferenceElement = referenceElement;
    }

    public GrClassReferenceType(GrReferenceElement referenceElement, LanguageLevel languageLevel) {
        super(languageLevel);
        this.myReferenceElement = referenceElement;
    }

    @Nullable
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Nullable
    public String getClassName() {
        PsiClass resolved = this.resolve();
        if (resolved != null) {
            return resolved.getName();
        }
        return this.myReferenceElement.getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.myReferenceElement.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "getParameters"));
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        final GroovyResolveResult resolveResult = this.myReferenceElement.advancedResolve();
        PsiClassType.ClassResolveResult classResolveResult = new PsiClassType.ClassResolveResult(){

            public PsiClass getElement() {
                PsiElement resolved = resolveResult.getElement();
                return resolved instanceof PsiClass ? (PsiClass)resolved : null;
            }

            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType$1", "getSubstitutor"));
                }
                return psiSubstitutor;
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return resolveResult.isAccessible();
            }

            public boolean isStaticsScopeCorrect() {
                return resolveResult.isStaticsOK();
            }

            @Nullable
            public PsiElement getCurrentFileResolveScope() {
                return resolveResult.getCurrentFileResolveContext();
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "resolveGenerics"));
        }
        return classResolveResult;
    }

    @NotNull
    public PsiClassType rawType() {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myReferenceElement.getProject());
        PsiClass clazz = this.resolve();
        if (clazz != null) {
            PsiClassType psiClassType = factory.createType(clazz, factory.createRawSubstitutor((PsiTypeParameterListOwner)clazz));
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "rawType"));
            }
            return psiClassType;
        }
        String qName = this.myReferenceElement.getClassNameText();
        PsiClassType psiClassType = factory.createTypeByFQClassName(qName, this.myReferenceElement.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "rawType"));
        }
        return psiClassType;
    }

    @NotNull
    public String getPresentableText() {
        String string = PsiNameHelper.getPresentableText((String)this.myReferenceElement.getReferenceName(), (PsiAnnotation[])PsiAnnotation.EMPTY_ARRAY, (PsiType[])this.myReferenceElement.getTypeArguments());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myReferenceElement.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "getCanonicalText"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myReferenceElement.isValid();
    }

    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "equalsToText"));
        }
        return text.endsWith(this.getPresentableText()) && text.equals(this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myReferenceElement.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "setLanguageLevel"));
        }
        GrClassReferenceType grClassReferenceType = new GrClassReferenceType(this.myReferenceElement, languageLevel);
        if (grClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType", "setLanguageLevel"));
        }
        return grClassReferenceType;
    }

    public GrReferenceElement getReference() {
        return this.myReferenceElement;
    }
}

