/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GroovyInArgumentCheckInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInArgumentCheckInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        PsiType ltype = (PsiType)args[0];
        PsiType rtype = (PsiType)args[1];
        return GroovyInspectionBundle.message("rtype.cannot.contain.ltype", ltype.getPresentableText(), rtype.getPresentableText());
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInArgumentCheckInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Incompatible 'in' argument types" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInArgumentCheckInspection", "getDisplayName"));
        }
        return "Incompatible 'in' argument types";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            PsiType component;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInArgumentCheckInspection$MyVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            if (expression.getOperationTokenType() != GroovyTokenTypes.kIN) {
                return;
            }
            GrExpression leftOperand = expression.getLeftOperand();
            GrExpression rightOperand = expression.getRightOperand();
            if (rightOperand == null) {
                return;
            }
            PsiType ltype = leftOperand.getType();
            PsiType rtype = rightOperand.getType();
            if (ltype == null || rtype == null) {
                return;
            }
            if (rtype instanceof PsiArrayType) {
                component = ((PsiArrayType)rtype).getComponentType();
            } else if (InheritanceUtil.isInheritor((PsiType)rtype, (String)"java.util.Collection")) {
                component = PsiUtil.substituteTypeParameter((PsiType)rtype, (String)"java.util.Collection", (int)0, (boolean)false);
            } else {
                this.checkSimpleClasses(ltype, rtype, expression);
                return;
            }
            if (component == null) {
                return;
            }
            if (TypesUtil.isAssignableWithoutConversions(component, ltype, expression)) {
                return;
            }
            this.registerError((PsiElement)expression, ltype, rtype);
        }

        private void checkSimpleClasses(PsiType ltype, PsiType rtype, GrBinaryExpression expression) {
            if (!(rtype instanceof PsiClassType)) {
                return;
            }
            if (!(ltype instanceof PsiClassType)) {
                return;
            }
            PsiClass lclass = ((PsiClassType)ltype).resolve();
            PsiClass rclass = ((PsiClassType)rtype).resolve();
            if (lclass == null || rclass == null) {
                return;
            }
            if (expression.getManager().areElementsEquivalent((PsiElement)lclass, (PsiElement)rclass)) {
                return;
            }
            if (lclass.isInterface() || rclass.isInterface()) {
                return;
            }
            if (lclass.isInheritor(rclass, true) || rclass.isInheritor(lclass, true)) {
                return;
            }
            this.registerError((PsiElement)expression, ltype, rtype);
        }
    }
}

