/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildOperationWorkerRegistry
implements BuildOperationWorkerRegistry,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildOperationWorkerRegistry.class);
    private final int maxWorkerCount;
    private final Object lock = new Object();
    private int counter = 1;
    private final Map<Thread, DefaultOperation> threads = new HashMap<Thread, DefaultOperation>();
    private final Root root = new Root();

    public DefaultBuildOperationWorkerRegistry(int maxWorkerCount) {
        this.maxWorkerCount = maxWorkerCount;
        LOGGER.debug("Using {} worker leases.", (Object)maxWorkerCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildOperationWorkerRegistry.Operation getCurrent() {
        Object object = this.lock;
        synchronized (object) {
            DefaultOperation operation = this.threads.get(Thread.currentThread());
            if (operation == null) {
                throw new IllegalStateException("No build operation associated with the current thread");
            }
            return operation;
        }
    }

    public BuildOperationWorkerRegistry.Completion operationStart() {
        return this.doStartOperation(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildOperationWorkerRegistry.Completion doStartOperation(LeaseHolder parent) {
        Object object = this.lock;
        synchronized (object) {
            int workerId = this.counter++;
            Thread ownerThread = Thread.currentThread();
            if (this.threads.containsKey(ownerThread)) {
                throw new UnsupportedOperationException("Cannot nest operations in the same thread. Each nested operation must run in its own thread.");
            }
            DefaultOperation operation = new DefaultOperation(parent, workerId, ownerThread);
            while (!parent.grantLease()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Worker {} waiting for a lease. Currently {} in use", (Object)operation.getDisplayName(), (Object)this.root.leasesInUse);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            this.threads.put(ownerThread, operation);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Worker {} started ({} in use).", (Object)operation.getDisplayName(), (Object)this.root.leasesInUse);
            }
            return operation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.threads.isEmpty()) {
                throw new IllegalStateException("Some build operations have not been marked as completed.");
            }
        }
    }

    private class DefaultOperation
    extends LeaseHolder
    implements BuildOperationWorkerRegistry.Completion,
    BuildOperationWorkerRegistry.Operation {
        private final LeaseHolder parent;
        private final int workerId;
        private final Thread ownerThread;
        int children;

        DefaultOperation(LeaseHolder parent, int workerId, Thread ownerThread) {
            this.parent = parent;
            this.workerId = workerId;
            this.ownerThread = ownerThread;
        }

        String getDisplayName() {
            return this.parent.getDisplayName() + '.' + this.workerId;
        }

        boolean grantLease() {
            if (this.children == 0 || DefaultBuildOperationWorkerRegistry.this.root.grantLease()) {
                ++this.children;
                return true;
            }
            return false;
        }

        void releaseLease() {
            --this.children;
            if (this.children > 0) {
                DefaultBuildOperationWorkerRegistry.this.root.releaseLease();
            }
        }

        public BuildOperationWorkerRegistry.Completion operationStart() {
            return DefaultBuildOperationWorkerRegistry.this.doStartOperation(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationFinish() {
            Object object = DefaultBuildOperationWorkerRegistry.this.lock;
            synchronized (object) {
                if (Thread.currentThread() != this.ownerThread) {
                    throw new UnsupportedOperationException("Must complete operation from owner thread.");
                }
                this.parent.releaseLease();
                DefaultBuildOperationWorkerRegistry.this.threads.remove(this.ownerThread);
                DefaultBuildOperationWorkerRegistry.this.lock.notifyAll();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Worker {} completed ({} in use)", (Object)this.getDisplayName(), (Object)((DefaultBuildOperationWorkerRegistry)DefaultBuildOperationWorkerRegistry.this).root.leasesInUse);
                }
                if (this.children != 0) {
                    throw new IllegalStateException("Some child operations have not yet completed.");
                }
            }
        }
    }

    private class Root
    extends LeaseHolder {
        int leasesInUse;

        private Root() {
        }

        public String getDisplayName() {
            return "root";
        }

        boolean grantLease() {
            if (this.leasesInUse >= DefaultBuildOperationWorkerRegistry.this.maxWorkerCount) {
                return false;
            }
            ++this.leasesInUse;
            return true;
        }

        void releaseLease() {
            --this.leasesInUse;
        }
    }

    private abstract class LeaseHolder {
        private LeaseHolder() {
        }

        abstract String getDisplayName();

        abstract boolean grantLease();

        abstract void releaseLease();
    }
}

