/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.segments;

import com.intellij.lang.ant.segments.SegmentedInputStream;
import java.io.IOException;
import java.io.Reader;

public class SegmentedInputStreamReader
extends Reader {
    private final SegmentedInputStream myStream;

    public SegmentedInputStreamReader(SegmentedInputStream stream) {
        this.myStream = stream;
    }

    @Override
    public void close() throws IOException {
        this.myStream.close();
    }

    @Override
    public boolean ready() throws IOException {
        return this.myStream.available() > 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int bytesRead = 0;
        while (this.ready() && bytesRead < len) {
            int aChar = this.myStream.read();
            if (aChar == -1) {
                return bytesRead == 0 ? -1 : bytesRead;
            }
            cbuf[off + bytesRead++] = (char)aChar;
        }
        return bytesRead;
    }
}

