/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.configuration;

import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public abstract class ChooseAndEditComboBoxController<Item, Ref> {
    private final ComboboxWithBrowseButton myCombobox;
    private final Convertor<Item, Ref> myToString;
    private final Map<Ref, Item> myItems = new HashMap();

    public ChooseAndEditComboBoxController(ComboboxWithBrowseButton combobox, Convertor<Item, Ref> toRef, Comparator<Ref> comparator) {
        this.myCombobox = combobox;
        this.myToString = toRef;
        this.myCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseAndEditComboBoxController.this.resetList(ChooseAndEditComboBoxController.this.openConfigureDialog(ChooseAndEditComboBoxController.this.myItems.get(ChooseAndEditComboBoxController.this.getSelectedString()), ChooseAndEditComboBoxController.this.getCombobox()));
            }
        });
        this.getCombobox().setModel(new SortedComboBoxModel(comparator));
    }

    public void resetList(Item selection) {
        Ref selectedItem = this.getSelectedString();
        this.myItems.clear();
        this.myItems.putAll(ContainerUtil.newMapFromValues(this.getAllListItems(), this.myToString));
        SortedComboBoxModel<Ref> model = this.getModel();
        model.setAll(this.myItems.keySet());
        if (selection != null) {
            model.setSelectedItem(this.myToString.convert(selection));
        } else {
            model.setSelectedItem(selectedItem);
        }
    }

    protected abstract Iterator<Item> getAllListItems();

    protected abstract Item openConfigureDialog(Item var1, JComponent var2);

    private Ref getSelectedString() {
        return (Ref)this.getCombobox().getSelectedItem();
    }

    private JComboBox getCombobox() {
        return this.myCombobox.getComboBox();
    }

    private SortedComboBoxModel<Ref> getModel() {
        return (SortedComboBoxModel)this.getCombobox().getModel();
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.myCombobox.getComboBox().setRenderer(renderer);
    }

    public Ref getSelectedItem() {
        return (Ref)this.myCombobox.getComboBox().getSelectedItem();
    }
}

