/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.importToCvs;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.ui.TagNameFieldOwner;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CvsFieldValidator {
    public static final char[] INVALID_CHARACTERS = new char[]{'`', '$', '.', ',', ':', ';', '@', '\'', ' '};

    private CvsFieldValidator() {
    }

    public static void reportError(JLabel errorLabel, String message, TagNameFieldOwner tagNameFieldOwner) {
        String text = "<html><font color='red'><b>" + message + "</b></font></html>";
        errorLabel.setText(text);
        if (tagNameFieldOwner != null) {
            tagNameFieldOwner.disableOkAction(message);
        }
    }

    public static void installOn(final TagNameFieldOwner dialog, final JTextField field, final JLabel label) {
        CvsFieldValidator.installOn(dialog, field, label, new AbstractButton[0]);
        field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                CvsFieldValidator.checkTagNameField(dialog, field, label);
            }
        });
        CvsFieldValidator.checkTagNameField(dialog, field, label);
    }

    public static void installOn(final TagNameFieldOwner dialog, final JTextField field, final JLabel label, AbstractButton[] buttons) {
        field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                CvsFieldValidator.checkTagNameField(dialog, field, label);
            }
        });
        for (AbstractButton button : buttons) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CvsFieldValidator.checkTagNameField(dialog, field, label);
                }
            });
        }
        CvsFieldValidator.checkTagNameField(dialog, field, label);
    }

    private static void checkTagNameField(TagNameFieldOwner dialog, JTextField field, JLabel label) {
        if (!dialog.tagFieldIsActive()) {
            label.setText(" ");
            dialog.enableOkAction();
        } else if (CvsFieldValidator.checkField(field, new JTextField[0], true, label, dialog)) {
            dialog.enableOkAction();
        } else {
            field.requestFocus();
        }
    }

    public static boolean checkField(JTextField field, JTextField[] shouldDifferFrom, boolean shouldStartFromLetter, JLabel errorLabel, TagNameFieldOwner tagNameFieldOwner) {
        String text = field.getText().trim();
        if (text.isEmpty()) {
            CvsFieldValidator.reportError(errorLabel, CvsBundle.message((String)"error.message.field.cannot.be.empty", (Object[])new Object[0]), tagNameFieldOwner);
            return false;
        }
        for (char invalidCharacter : INVALID_CHARACTERS) {
            if (text.indexOf(invalidCharacter) == -1) continue;
            CvsFieldValidator.reportError(errorLabel, CvsBundle.message((String)"error.message.field.contains.invalid.characters", (Object[])new Object[0]), tagNameFieldOwner);
            return false;
        }
        for (JTextField jTextField : shouldDifferFrom) {
            if (jTextField == field || !jTextField.getText().trim().equals(text)) continue;
            CvsFieldValidator.reportError(errorLabel, CvsBundle.message((String)"error.message.duplicate.field.value", (Object[])new Object[0]), tagNameFieldOwner);
            return false;
        }
        if (shouldStartFromLetter && !Character.isLetter(text.charAt(0))) {
            CvsFieldValidator.reportError(errorLabel, CvsBundle.message((String)"error.message.field.value.must.start.with.a.letter", (Object[])new Object[0]), tagNameFieldOwner);
            return false;
        }
        errorLabel.setText(" ");
        return true;
    }
}

