/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestExtensionContext;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.ConditionEvaluator;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.ThrowableCollector;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public class MethodTestDescriptor
extends JupiterTestDescriptor {
    private static final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();
    private final Class<?> testClass;
    private final Method testMethod;

    public MethodTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        super(uniqueId, MethodTestDescriptor.determineDisplayName((AnnotatedElement)Preconditions.notNull((Object)testMethod, (String)"Method must not be null"), MethodTestDescriptor::generateDefaultDisplayName));
        this.testClass = (Class)Preconditions.notNull(testClass, (String)"Class must not be null");
        this.testMethod = testMethod;
        this.setSource((TestSource)new MethodSource(testMethod));
    }

    public final Set<TestTag> getTags() {
        Set<TestTag> methodTags = MethodTestDescriptor.getTags(this.getTestMethod());
        this.getParent().ifPresent(parentDescriptor -> methodTags.addAll(parentDescriptor.getTags()));
        return methodTags;
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    protected static String generateDefaultDisplayName(Method testMethod) {
        return String.format("%s(%s)", testMethod.getName(), StringUtils.nullSafeToString(Class::getSimpleName, (Class[])testMethod.getParameterTypes()));
    }

    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) throws Exception {
        ExtensionRegistry registry = this.populateNewExtensionRegistryFromExtendWith(this.testMethod, context.getExtensionRegistry());
        Object testInstance = context.getTestInstanceProvider().getTestInstance();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        MethodBasedTestExtensionContext testExtensionContext = new MethodBasedTestExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, testInstance, throwableCollector);
        return context.extend().withExtensionRegistry(registry).withExtensionContext(testExtensionContext).withThrowableCollector(throwableCollector).build();
    }

    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) throws Exception {
        ConditionEvaluationResult evaluationResult = conditionEvaluator.evaluateForTest(context.getExtensionRegistry(), context.getConfigurationParameters(), (TestExtensionContext)context.getExtensionContext());
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip((String)evaluationResult.getReason().orElse("<unknown>"));
        }
        return Node.SkipResult.doNotSkip();
    }

    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context) throws Exception {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        this.invokeBeforeEachCallbacks(context);
        if (throwableCollector.isEmpty()) {
            this.invokeBeforeEachMethods(context);
            if (throwableCollector.isEmpty()) {
                this.invokeBeforeTestExecutionCallbacks(context);
                if (throwableCollector.isEmpty()) {
                    this.invokeTestMethod(context);
                }
                this.invokeAfterTestExecutionCallbacks(context);
            }
            this.invokeAfterEachMethods(context);
        }
        this.invokeAfterEachCallbacks(context);
        throwableCollector.assertEmpty();
        return context;
    }

    private void invokeBeforeEachCallbacks(JupiterEngineExecutionContext context) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context, (extensionContext, callback) -> () -> callback.beforeEach(extensionContext), BeforeEachCallback.class);
    }

    private void invokeBeforeEachMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context, (extensionContext, adapter) -> () -> adapter.invokeBeforeEachMethod((TestExtensionContext)extensionContext, registry), BeforeEachMethodAdapter.class);
    }

    private void invokeBeforeTestExecutionCallbacks(JupiterEngineExecutionContext context) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context, (extensionContext, callback) -> () -> callback.beforeTestExecution(extensionContext), BeforeTestExecutionCallback.class);
    }

    private <T extends Extension> void invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(JupiterEngineExecutionContext context, BiFunction<TestExtensionContext, T, Executable> generator, Class<T> type) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        TestExtensionContext testExtensionContext = (TestExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (Extension callback : registry.getExtensions(type)) {
            Executable executable = generator.apply(testExtensionContext, (TestExtensionContext)callback);
            throwableCollector.execute(executable);
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    protected void invokeTestMethod(JupiterEngineExecutionContext context) {
        TestExtensionContext testExtensionContext = (TestExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        throwableCollector.execute(() -> {
            try {
                Method method = (Method)testExtensionContext.getTestMethod().get();
                Object instance = testExtensionContext.getTestInstance();
                executableInvoker.invoke(method, instance, (ExtensionContext)testExtensionContext, context.getExtensionRegistry());
            }
            catch (Throwable throwable) {
                this.invokeTestExecutionExceptionHandlers(context.getExtensionRegistry(), testExtensionContext, throwable);
            }
        });
    }

    private void invokeTestExecutionExceptionHandlers(ExtensionRegistry registry, TestExtensionContext context, Throwable ex) {
        this.invokeTestExecutionExceptionHandlers(ex, registry.getExtensions(TestExecutionExceptionHandler.class), context);
    }

    private void invokeTestExecutionExceptionHandlers(Throwable ex, List<TestExecutionExceptionHandler> handlers, TestExtensionContext context) {
        if (handlers.isEmpty()) {
            ExceptionUtils.throwAsUncheckedException((Throwable)ex);
        }
        try {
            handlers.remove(0).handleTestExecutionException(context, ex);
        }
        catch (Throwable t) {
            this.invokeTestExecutionExceptionHandlers(t, handlers, context);
        }
    }

    private void invokeAfterTestExecutionCallbacks(JupiterEngineExecutionContext context) {
        this.invokeAllAfterMethodsOrCallbacks(context, (extensionContext, callback) -> () -> callback.afterTestExecution(extensionContext), AfterTestExecutionCallback.class);
    }

    private void invokeAfterEachMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        this.invokeAllAfterMethodsOrCallbacks(context, (extensionContext, adapter) -> () -> adapter.invokeAfterEachMethod((TestExtensionContext)extensionContext, registry), AfterEachMethodAdapter.class);
    }

    private void invokeAfterEachCallbacks(JupiterEngineExecutionContext context) {
        this.invokeAllAfterMethodsOrCallbacks(context, (extensionContext, callback) -> () -> callback.afterEach(extensionContext), AfterEachCallback.class);
    }

    private <T extends Extension> void invokeAllAfterMethodsOrCallbacks(JupiterEngineExecutionContext context, BiFunction<TestExtensionContext, T, Executable> generator, Class<T> type) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        TestExtensionContext testExtensionContext = (TestExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        registry.getReversedExtensions(type).forEach(callback -> {
            Executable executable = (Executable)generator.apply(testExtensionContext, callback);
            throwableCollector.execute(executable);
        });
    }
}

