# Copyright 2016 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Definitiones compute scopes (locations)."""

import enum

from googlecloudsdk.core import exceptions


class ScopeEnum(enum.Enum):
  """Enum representing GCE scope."""

  ZONE = ('zone', 'a ')
  REGION = ('region', 'a ')
  GLOBAL = ('global', '')

  def __init__(self, flag_name, prefix):
    # Collection parameter name matches command line file in this case.
    self.param_name = flag_name
    self.flag_name = flag_name
    self.prefix = prefix

  @classmethod
  def CollectionForScope(cls, scope):
    if scope == cls.ZONE:
      return 'compute.zones'
    if scope == cls.REGION:
      return 'compute.regions'
    raise exceptions.Error(
        'Expected scope to be ZONE or REGION, got {0!r}'.format(scope))
